/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ease.debugging.ScriptDebugElement;
import org.eclipse.ease.debugging.ScriptDebugStackFrame;

public class ScriptDebugValue
extends ScriptDebugElement
implements IValue {
    private final ScriptDebugStackFrame fStackFrame;
    private final Object fValue;

    public ScriptDebugValue(ScriptDebugStackFrame stackFrame, Object value) {
        super(stackFrame.getDebugTarget());
        this.fStackFrame = stackFrame;
        this.fValue = value;
    }

    public boolean isTerminated() {
        return this.fStackFrame.isTerminated();
    }

    public boolean isSuspended() {
        return this.fStackFrame.isSuspended();
    }

    public boolean isStepping() {
        return this.fStackFrame.isStepping();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fValue != null ? this.fValue.getClass().getSimpleName() : "";
    }

    public String getValueString() throws DebugException {
        if (ScriptDebugValue.isSimpleType(this.fValue)) {
            return this.fValue + " (" + this.fValue.getClass().getSimpleName().toLowerCase() + ")";
        }
        if (this.fValue instanceof String) {
            return "\"" + this.fValue + "\"";
        }
        return this.fValue != null ? this.fValue.getClass().getSimpleName() : "null";
    }

    public boolean isAllocated() throws DebugException {
        return this.fValue != null;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] children = this.fStackFrame.getVariables(this.fValue);
        if (children != null) {
            return children;
        }
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public Object getAdapter(Class adapter) {
        if (String.class.equals((Object)adapter)) {
            return this.fValue != null ? this.fValue.toString() : "";
        }
        return super.getAdapter(adapter);
    }

    public Object getValue() {
        return this.fValue;
    }

    public static boolean isSimpleType(Object value) {
        return value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Double || value instanceof Float;
    }
}

