/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.util.Map;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.IDefinitionFactory;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.impl.FlagToStringMap;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.ease.lang.unittest.ui.dialogs.HTMLContentDialog;
import org.eclipse.ease.lang.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.ease.lang.unittest.ui.views.SuiteRuntimeInformation;
import org.eclipse.ease.lang.unittest.ui.views.UnitTestView;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPage
extends AbstractEditorPage {
    private Text fTxtThreads;
    private Browser fBrowser;
    private Button fChkPromoteFailuresToErrors;
    private Button fChkStopSuiteOnError;
    private Button fChkRunTeardownOnError;
    private ComboViewer fEngineComboViewer;
    private Label fLblTestFilesCount;
    private Label fLblDefinedVariablesCount;
    private Label fLblDisabledFilesCount;
    private Label fLblExpectedRuntime;
    private Label fLblUsesSetupTeardown;
    private Hyperlink fHprlnkSetupTeardownCode;

    public OverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(2, true));
        Section sctnDescription = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 258);
        sctnDescription.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        managedForm.getToolkit().paintBordersFor((Composite)sctnDescription);
        sctnDescription.setText("Description");
        sctnDescription.setExpanded(true);
        Composite composite = new Composite((Composite)sctnDescription, 0);
        managedForm.getToolkit().adapt(composite);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnDescription.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fBrowser = new Browser(composite, 0);
        this.fBrowser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        managedForm.getToolkit().adapt((Composite)this.fBrowser);
        managedForm.getToolkit().paintBordersFor((Composite)this.fBrowser);
        Hyperlink hprlnkEdit = managedForm.getToolkit().createHyperlink(composite, "edit", 0);
        hprlnkEdit.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        hprlnkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                HTMLContentDialog htmlContentDialog = new HTMLContentDialog(OverviewPage.this.getEditorSite().getShell(), OverviewPage.this.getTestSuitDefinition().getDescription());
                if (htmlContentDialog.open() == 0) {
                    OverviewPage.this.updateDescription(htmlContentDialog.getContent());
                    OverviewPage.this.fBrowser.setText(htmlContentDialog.getContent());
                }
            }
        });
        managedForm.getToolkit().paintBordersFor((Composite)hprlnkEdit);
        Section sctnSummary = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 258);
        sctnSummary.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        managedForm.getToolkit().paintBordersFor((Composite)sctnSummary);
        sctnSummary.setText("Summary");
        sctnSummary.setExpanded(true);
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)sctnSummary, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        sctnSummary.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(3, false));
        Label lblNewLabel = managedForm.getToolkit().createLabel(composite_1, "Test files", 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fLblTestFilesCount = managedForm.getToolkit().createLabel(composite_1, "0", 0);
        this.fLblTestFilesCount.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Label lblDisabledFiles = managedForm.getToolkit().createLabel(composite_1, "Disabled files", 0);
        lblDisabledFiles.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fLblDisabledFilesCount = managedForm.getToolkit().createLabel(composite_1, "0", 0);
        this.fLblDisabledFilesCount.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Label lblExpectedExecutionTime = managedForm.getToolkit().createLabel(composite_1, "Expected execution time", 0);
        lblExpectedExecutionTime.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fLblExpectedRuntime = managedForm.getToolkit().createLabel(composite_1, "unknown", 0);
        this.fLblExpectedRuntime.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Hyperlink hprlnkDefinedVariables = managedForm.getToolkit().createHyperlink(composite_1, "Defined variables", 0);
        hprlnkDefinedVariables.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().paintBordersFor((Composite)hprlnkDefinedVariables);
        hprlnkDefinedVariables.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("Variables");
            }
        });
        this.fLblDefinedVariablesCount = managedForm.getToolkit().createLabel(composite_1, "0", 0);
        this.fLblDefinedVariablesCount.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fLblUsesSetupTeardown = managedForm.getToolkit().createLabel(composite_1, "Uses", 0);
        this.fLblUsesSetupTeardown.setVisible(false);
        this.fHprlnkSetupTeardownCode = managedForm.getToolkit().createHyperlink(composite_1, "Setup/Teardown code", 0);
        managedForm.getToolkit().paintBordersFor((Composite)this.fHprlnkSetupTeardownCode);
        this.fHprlnkSetupTeardownCode.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("Custom Code");
            }
        });
        this.fHprlnkSetupTeardownCode.setVisible(false);
        new Label(composite_1, 0);
        Section sctnSettings = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 258);
        sctnSettings.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        managedForm.getToolkit().paintBordersFor((Composite)sctnSettings);
        sctnSettings.setText("Settings");
        sctnSettings.setExpanded(true);
        Composite composite_2 = managedForm.getToolkit().createComposite((Composite)sctnSettings, 0);
        managedForm.getToolkit().paintBordersFor(composite_2);
        sctnSettings.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new GridLayout(2, false));
        Label lblThreads = new Label(composite_2, 0);
        lblThreads.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)lblThreads, true, true);
        lblThreads.setText("Threads:");
        this.fTxtThreads = managedForm.getToolkit().createText(composite_2, "New Text", 0);
        this.fTxtThreads.setText("1");
        this.fTxtThreads.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fTxtThreads.addVerifyListener(e -> {
            boolean bl = e.doit = e.character >= '0' && e.character <= '9' || e.character == '\u007f' || e.character == '\b';
        });
        Label lblEngine = managedForm.getToolkit().createLabel(composite_2, "Engine:", 0);
        lblEngine.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        CCombo combo_1 = new CCombo(composite_2, 2048);
        combo_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        managedForm.getToolkit().adapt((Composite)combo_1);
        managedForm.getToolkit().paintBordersFor((Composite)combo_1);
        this.fEngineComboViewer = new ComboViewer(combo_1);
        this.fEngineComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fEngineComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EngineDescription) {
                    return ((EngineDescription)element).getName();
                }
                return super.getText(element);
            }
        });
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        this.fEngineComboViewer.setInput((Object)scriptService.getEngines());
        Label label = new Label(composite_2, 258);
        GridData gd_label = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_label.verticalIndent = 10;
        label.setLayoutData((Object)gd_label);
        managedForm.getToolkit().adapt((Control)label, true, true);
        this.fChkPromoteFailuresToErrors = new Button(composite_2, 32);
        this.fChkPromoteFailuresToErrors.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)this.fChkPromoteFailuresToErrors, true, true);
        this.fChkPromoteFailuresToErrors.setText("Promote Failures to Errors");
        this.fChkStopSuiteOnError = new Button(composite_2, 32);
        this.fChkStopSuiteOnError.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)this.fChkStopSuiteOnError, true, true);
        this.fChkStopSuiteOnError.setText("Stop suite on error");
        this.fChkRunTeardownOnError = new Button(composite_2, 32);
        this.fChkRunTeardownOnError.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)this.fChkRunTeardownOnError, true, true);
        this.fChkRunTeardownOnError.setText("Run teardown on error");
        this.populateContent();
        this.fTxtThreads.addModifyListener(e -> this.updateFlag(Flag.THREAD_COUNT, this.fTxtThreads.getText()));
        this.fEngineComboViewer.addSelectionChangedListener(event -> {
            Object element = this.fEngineComboViewer.getStructuredSelection().getFirstElement();
            if (element instanceof EngineDescription) {
                this.updateFlag(Flag.PREFERRED_ENGINE_ID, ((EngineDescription)element).getID());
            } else {
                this.updateFlag(Flag.PREFERRED_ENGINE_ID, "");
            }
        });
        this.fChkPromoteFailuresToErrors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewPage.this.updateFlag(Flag.PROMOTE_FAILURE_TO_ERROR, Boolean.toString(OverviewPage.this.fChkPromoteFailuresToErrors.getSelection()));
            }
        });
        this.fChkStopSuiteOnError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewPage.this.updateFlag(Flag.STOP_SUITE_ON_ERROR, Boolean.toString(OverviewPage.this.fChkStopSuiteOnError.getSelection()));
            }
        });
        this.fChkRunTeardownOnError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewPage.this.updateFlag(Flag.RUN_TEARDOWN_ON_ERROR, Boolean.toString(OverviewPage.this.fChkRunTeardownOnError.getSelection()));
            }
        });
    }

    private void updateFlag(Flag flag, String value) {
        CompoundCommand compoundCommand = new CompoundCommand();
        if (this.getTestSuitDefinition().getFlags().containsKey((Object)flag)) {
            Map.Entry entry = (Map.Entry)this.getTestSuitDefinition().getFlags().get(this.getTestSuitDefinition().getFlags().indexOfKey((Object)flag));
            Command removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuitDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__FLAGS, (Object)entry);
            compoundCommand.append(removeCommand);
        }
        FlagToStringMap newentry = (FlagToStringMap)IDefinitionFactory.eINSTANCE.create(IDefinitionPackage.Literals.FLAG_TO_STRING_MAP);
        newentry.setKey(flag);
        newentry.setValue(value);
        Command addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuitDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__FLAGS, (Object)newentry);
        compoundCommand.append(addCommand);
        this.executeCommand((Command)compoundCommand);
    }

    protected void updateDescription(String content) {
        Command command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuitDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__DESCRIPTION, (Object)content);
        this.executeCommand(command);
    }

    @Override
    protected void populateContent() {
        IScriptService scriptService;
        EngineDescription engineDescription;
        String description = this.getTestSuitDefinition().getDescription();
        if (description != null) {
            this.fBrowser.setText(description);
        }
        this.fTxtThreads.setText(Integer.toString((Integer)this.getTestSuitDefinition().getFlag(Flag.THREAD_COUNT, (Object)1)));
        this.fChkPromoteFailuresToErrors.setSelection(((Boolean)this.getTestSuitDefinition().getFlag(Flag.PROMOTE_FAILURE_TO_ERROR, (Object)false)).booleanValue());
        this.fChkStopSuiteOnError.setSelection(((Boolean)this.getTestSuitDefinition().getFlag(Flag.STOP_SUITE_ON_ERROR, (Object)false)).booleanValue());
        this.fChkRunTeardownOnError.setSelection(((Boolean)this.getTestSuitDefinition().getFlag(Flag.RUN_TEARDOWN_ON_ERROR, (Object)true)).booleanValue());
        String selectedEngine = (String)this.getTestSuitDefinition().getFlag(Flag.PREFERRED_ENGINE_ID, (Object)"");
        if (!selectedEngine.isEmpty() && (engineDescription = (scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class)).getEngineByID(selectedEngine)) != null) {
            this.fEngineComboViewer.setSelection((ISelection)new StructuredSelection((Object)engineDescription));
        }
    }

    @Override
    protected String getPageTitle() {
        String name = this.getTestSuitDefinition().getName();
        return name != null && !name.isEmpty() ? name : "Overview";
    }

    public Image getTitleImage() {
        return Activator.getImage("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/testsuite.png", true);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.fLblTestFilesCount != null && !this.fLblTestFilesCount.isDisposed()) {
            ITestSuite testSuite = UnitTestHelper.createRuntimeSuite((ITestSuiteDefinition)this.getTestSuitDefinition());
            this.fLblTestFilesCount.setText(Integer.toString(UnitTestHelper.getTestFiles((ITestContainer)testSuite).size()));
            this.fLblDisabledFilesCount.setText(Integer.toString(this.getDisabledFilesCount((ITestContainer)testSuite)));
            this.fLblDefinedVariablesCount.setText(Integer.toString(this.getTestSuitDefinition().getVariables().size()));
            long runtime = this.calculateExpectedRuntime(testSuite);
            if (runtime < 0L) {
                this.fLblExpectedRuntime.setText("unknown");
            } else {
                this.fLblExpectedRuntime.setText(UnitTestView.getDurationString(runtime));
            }
            this.fLblUsesSetupTeardown.setVisible(!this.getTestSuitDefinition().getCustomCode().isEmpty());
            this.fHprlnkSetupTeardownCode.setVisible(!this.getTestSuitDefinition().getCustomCode().isEmpty());
        }
    }

    private long calculateExpectedRuntime(ITestSuite testSuite) {
        SuiteRuntimeInformation runtimeInformation = new SuiteRuntimeInformation(testSuite);
        long totalEstimation = 0L;
        for (ITestFile testFile : UnitTestHelper.getTestFiles((ITestContainer)testSuite)) {
            long estimatedTestFileDuration = runtimeInformation.getEstimatedDuration(testFile.getFullPath().makeAbsolute());
            if (estimatedTestFileDuration < 0L) {
                return -1L;
            }
            totalEstimation += estimatedTestFileDuration;
        }
        return totalEstimation;
    }

    private int getDisabledFilesCount(ITestContainer testContainer) {
        int sum = 0;
        for (ITestFile testFile : UnitTestHelper.getTestFiles((ITestContainer)testContainer)) {
            sum += this.getTestSuitDefinition().getDisabledResources().contains((Object)testFile.getFullPath().removeFirstSegments(1).makeAbsolute()) ? 1 : 0;
        }
        return sum;
    }
}

