/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.PlatformUI;

public class ScriptingModule
extends AbstractScriptModule {
    @WrapToScript
    public IScriptEngine createScriptEngine(String identifier) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        EngineDescription engine = scriptService.getEngineByID(identifier);
        if (engine != null) {
            return engine.createEngine();
        }
        Collection engines = scriptService.getEngines();
        for (EngineDescription description : engines) {
            if (!description.getName().equals(identifier)) continue;
            return description.createEngine();
        }
        engine = scriptService.getEngine(identifier);
        if (engine != null) {
            return engine.createEngine();
        }
        return null;
    }

    @WrapToScript
    public String[] listScriptEngines() {
        ArrayList<String> result = new ArrayList<String>();
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        for (EngineDescription description : scriptService.getEngines()) {
            result.add(description.getID());
        }
        return result.toArray(new String[result.size()]);
    }

    @WrapToScript
    public IScriptEngine fork(Object resource, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String arguments, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String engineID) {
        List engines;
        String location;
        ScriptType scriptType;
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        if (engineID == null && (scriptType = scriptService.getScriptType(location = ResourceTools.toAbsoluteLocation((Object)resource, (Object)this.getScriptEngine().getExecutedFile()))) != null && !(engines = scriptType.getEngines()).isEmpty()) {
            engineID = ((EngineDescription)engines.get(0)).getID();
        }
        if (engineID != null) {
            IScriptEngine engine = scriptService.getEngineByID(engineID).createEngine();
            engine.setOutputStream((OutputStream)this.getScriptEngine().getOutputStream());
            engine.setErrorStream((OutputStream)this.getScriptEngine().getErrorStream());
            engine.setInputStream(this.getScriptEngine().getInputStream());
            engine.setCloseStreamsOnTerminate(false);
            engine.setVariable("argv", (Object)AbstractScriptEngine.extractArguments((String)arguments));
            Object scriptObject = ResourceTools.resolveFile((Object)resource, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
            if (scriptObject == null) {
                try {
                    scriptObject = URI.create(resource.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            engine.executeAsync(scriptObject);
            engine.schedule();
            return engine;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WrapToScript
    public boolean join(IScriptEngine engine, @ScriptParameter(defaultValue="0") long timeout) {
        if (!(engine instanceof Job)) throw new RuntimeException("Cannot evaluate engine state");
        long stopWaitingTime = System.currentTimeMillis() + timeout;
        try {
            while (true) {
                if (((Job)engine).getState() == 0) {
                    return true;
                }
                long now = System.currentTimeMillis();
                if (timeout == 0L) {
                    Thread.sleep(1000L);
                    continue;
                }
                if (stopWaitingTime <= now) return false;
                Thread.sleep(Math.min(stopWaitingTime - now, 1000L));
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

