/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.preferences;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferencesHelper {
    @Deprecated
    private PreferencesHelper() {
    }

    public static String getScriptStorageLocation() {
        String location = PreferencesHelper.getUserScriptStorageLocation();
        if (location != null) {
            return location;
        }
        return PreferencesHelper.getDefaultScriptStorageLocation();
    }

    public static String getUserScriptStorageLocation() {
        final StringBuilder location = new StringBuilder();
        final IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui");
        try {
            rootNode.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    if (rootNode.equals(node)) {
                        return true;
                    }
                    if (node.getBoolean("default", false)) {
                        location.replace(0, location.length(), node.get("location", ""));
                    }
                    return false;
                }
            });
        }
        catch (BackingStoreException backingStoreException) {}
        if (location.length() > 0) {
            return location.toString();
        }
        return null;
    }

    public static String getDefaultScriptStorageLocation() {
        return ResourceTools.toURI((IPath)Activator.getDefault().getStateLocation().append("recordedScripts")).toASCIIString();
    }

    public static Collection<IScriptLocation> getLocations() {
        final HashSet<IScriptLocation> locations = new HashSet<IScriptLocation>();
        final IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui");
        try {
            rootNode.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    if (rootNode.equals(node)) {
                        return true;
                    }
                    String location = node.get("location", "");
                    if (!location.isEmpty()) {
                        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
                        entry.setLocation(location);
                        entry.setDefault(node.getBoolean("default", false));
                        entry.setRecursive(node.getBoolean("recursive", true));
                        locations.add(entry);
                    }
                    return false;
                }
            });
        }
        catch (BackingStoreException backingStoreException) {}
        return locations;
    }

    public static void addLocation(IScriptLocation entry) {
        String path = entry.getLocation().replace('/', '|');
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui/" + path);
        node.put("location", entry.getLocation());
        node.putBoolean("default", entry.isDefault());
        node.putBoolean("recursive", entry.isRecursive());
    }

    public static void addLocation(String location, boolean defaultLocation, boolean recursive) {
        IScriptLocation entry = IRepositoryFactory.eINSTANCE.createScriptLocation();
        entry.setLocation(location);
        entry.setRecursive(recursive);
        entry.setDefault(defaultLocation);
        PreferencesHelper.addLocation(entry);
    }

    public static void clearLocations() throws BackingStoreException {
        final IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui");
        rootNode.accept(new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                if (rootNode.equals(node)) {
                    return true;
                }
                node.removeNode();
                return false;
            }
        });
    }
}

