/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.ease.lang.unittest.execution.ITestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.runtime.impl.TestEntity;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class TestContainer
extends TestEntity
implements ITestContainer {
    protected EList<ITestEntity> children;
    protected static final Object RESOURCE_EDEFAULT = null;
    protected Object resource = RESOURCE_EDEFAULT;

    protected TestContainer() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRuntimePackage.Literals.TEST_CONTAINER;
    }

    @Override
    public EList<ITestEntity> getChildren() {
        if (this.children == null) {
            this.children = new EObjectContainmentWithInverseEList(ITestEntity.class, (InternalEObject)this, 11, 5);
        }
        return this.children;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Object newResource) {
        Object oldResource = this.resource;
        this.resource = newResource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldResource, this.resource));
        }
    }

    @Override
    public ITest getTest(String name) {
        ITestEntity[] iTestEntityArray = (ITestEntity[])this.getChildren().toArray((Object[])new ITestEntity[0]);
        int n = iTestEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestEntity child = iTestEntityArray[n2];
            if (child instanceof ITest && name.equals(child.getName())) {
                return (ITest)child;
            }
            ++n2;
        }
        ITest test = IRuntimeFactory.eINSTANCE.createTest();
        test.setName(name);
        this.getChildren().add((Object)test);
        return test;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getChildren();
            }
            case 12: {
                return this.getResource();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setResource(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getChildren().clear();
                return;
            }
            case 12: {
                this.setResource(RESOURCE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.children != null && !this.children.isEmpty();
            }
            case 12: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 13: {
                return this.getTest((String)arguments.get(0));
            }
            case 14: {
                return this.getChildContainers();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resource: ");
        result.append(this.resource);
        result.append(')');
        return result.toString();
    }

    @Override
    public void run(ITestExecutionStrategy strategy) {
        this.setEntityStatus(TestStatus.RUNNING);
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (!this.isTerminated() && child instanceof ITestContainer) {
                strategy.execute((ITestEntity)child);
            }
            ++n2;
        }
        this.setEntityStatus(TestStatus.FINISHED);
    }

    @Override
    public EList<ITestContainer> getChildContainers() {
        BasicEList result = new BasicEList();
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof ITestContainer) {
                result.add((Object)((ITestContainer)child));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public TestStatus getStatus() {
        int status = super.getStatus().getValue();
        ITestEntity[] iTestEntityArray = (ITestEntity[])this.getChildren().toArray((Object[])new ITestEntity[0]);
        int n = iTestEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestEntity child = iTestEntityArray[n2];
            status = Math.max(status, child.getStatus().getValue());
            ++n2;
        }
        return TestStatus.get(status);
    }

    @Override
    public boolean hasError() {
        ITestEntity[] iTestEntityArray = (ITestEntity[])this.getChildren().toArray((Object[])new ITestEntity[0]);
        int n = iTestEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestEntity child = iTestEntityArray[n2];
            if (child.hasError()) {
                return true;
            }
            ++n2;
        }
        return super.hasError();
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof ITest) {
                this.getChildren().remove(child);
            }
            ++n2;
        }
        super.reset();
    }

    @Override
    public long getEstimatedDuration() {
        long duration = super.getEstimatedDuration();
        if (duration < 0L && !this.getChildren().isEmpty()) {
            duration = 0L;
            for (ITestEntity child : this.getChildren()) {
                long childDuration = child.getEstimatedDuration();
                if (childDuration < 0L) {
                    return childDuration;
                }
                duration += childDuration;
            }
            return duration;
        }
        return super.getEstimatedDuration();
    }

    @Override
    public void setTerminated(boolean newTerminated) {
        super.setTerminated(newTerminated);
        ITestEntity[] iTestEntityArray = (ITestEntity[])this.getChildren().toArray((Object[])new ITestEntity[0]);
        int n = iTestEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestEntity child = iTestEntityArray[n2];
            child.setTerminated(newTerminated);
            ++n2;
        }
    }
}

