/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views.format;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.dirigible.ide.db.viewer.views.format.ColumnDescriptor;
import org.eclipse.dirigible.ide.db.viewer.views.format.ResultSetStringWriter;
import org.eclipse.dirigible.ide.db.viewer.views.format.RowFormatter;

public class StringRowFormatter
implements RowFormatter<String> {
    private static final String VALUE_NULL = "[NULL]";
    private static final String VALUE_BINARY = "[BINARY]";
    public static final int[] BINARY_TYPES;

    static {
        int[] nArray = new int[17];
        nArray[0] = 2003;
        nArray[1] = -2;
        nArray[2] = -7;
        nArray[3] = -7;
        nArray[4] = 2004;
        nArray[5] = 2005;
        nArray[6] = 70;
        nArray[7] = 2001;
        nArray[8] = 2000;
        nArray[9] = -4;
        nArray[10] = 2011;
        nArray[12] = 1111;
        nArray[13] = 2006;
        nArray[14] = 2009;
        nArray[15] = 2002;
        nArray[16] = -3;
        BINARY_TYPES = nArray;
    }

    @Override
    public String write(List<ColumnDescriptor> columnDescriptors, ResultSetMetaData resultSetMetaData, ResultSet resultSet) throws SQLException {
        StringBuilder buff = new StringBuilder();
        buff.append("|");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            String value = null;
            if (columnDescriptor.getSqlType() == Integer.MIN_VALUE) {
                value = "";
            } else {
                value = this.isBinaryType(columnDescriptor.getSqlType()) ? VALUE_BINARY : resultSet.getString(columnDescriptor.getLabel());
                if (value == null) {
                    value = VALUE_NULL;
                }
                if (!VALUE_BINARY.equals(value) || !VALUE_NULL.equals(value)) {
                    int delta = value.length() - columnDescriptor.getDisplaySize();
                    if (delta > 0) {
                        if ((value = value.substring(0, columnDescriptor.getDisplaySize())).length() > 3) {
                            value = String.valueOf(value.substring(0, value.length() - 3)) + "...";
                        }
                    } else if (delta < 0) {
                        value = String.format("%-" + columnDescriptor.getDisplaySize() + "s", value);
                    }
                }
            }
            buff.append(value);
            buff.append("|");
        }
        buff.append(ResultSetStringWriter.NEWLINE_CHARACTER);
        return buff.toString();
    }

    boolean isBinaryType(int columnType) {
        int[] nArray = BINARY_TYPES;
        int n = BINARY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            if (columnType == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

