/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewContentProvider;

public class TableDefinition {
    private static final String EMPTY = "";
    private static final String DOT = ".";
    private static final String QUOTES = "\"";
    private String catalogName = null;
    private String schemaName = null;
    private final String tableName;
    private List<DatabaseViewContentProvider.Capability> capabilities;
    private String contentScript;

    public TableDefinition(String tableName) {
        this.tableName = tableName;
        this.capabilities = new ArrayList<DatabaseViewContentProvider.Capability>();
    }

    public TableDefinition(String catalogName, String schemaName, String tableName) {
        this(tableName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    public TableDefinition(String catalogName, String schemaName, String tableName, List<DatabaseViewContentProvider.Capability> capabilities) {
        this(catalogName, schemaName, tableName);
        this.capabilities = capabilities;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setContentScript(String script) {
        this.contentScript = script;
    }

    public String getContentScript() {
        return this.contentScript;
    }

    public List<DatabaseViewContentProvider.Capability> getCapabilities() {
        return this.capabilities;
    }

    public int hashCode() {
        return this.getFqn().hashCode();
    }

    public boolean equals(Object obj) {
        if (TableDefinition.class.isInstance(obj)) {
            TableDefinition nDef = (TableDefinition)obj;
            String nDefString = String.valueOf(nDef.getCatalogName()) + DOT + nDef.getSchemaName() + DOT + nDef.getTableName();
            String oDefString = String.valueOf(this.getCatalogName()) + DOT + this.getSchemaName() + DOT + this.getTableName();
            return nDefString.equals(oDefString);
        }
        return super.equals(obj);
    }

    public String getFqn() {
        return String.valueOf(this.getSchemaName() != null ? QUOTES + this.getSchemaName() + QUOTES + DOT : EMPTY) + QUOTES + this.getTableName() + QUOTES;
    }
}

