/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeBridgeInjector
implements IInjector {
    public static final String DIRIGIBLE_RUNTIME_BRIDGE = "dirigible.runtime.bridge";
    private static final Logger logger = LoggerFactory.getLogger(RuntimeBridgeInjector.class);

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PropertyChangeSupport sessionRuntimeBridge = (PropertyChangeSupport)req.getSession().getAttribute(DIRIGIBLE_RUNTIME_BRIDGE);
        if (sessionRuntimeBridge == null) {
            PropertyChangeSupport runtimeBridge = this.lookupRuntimeBridge();
            try {
                req.getSession().setAttribute(DIRIGIBLE_RUNTIME_BRIDGE, (Object)runtimeBridge);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
    }

    private PropertyChangeSupport lookupRuntimeBridge() {
        return (PropertyChangeSupport)System.getProperties().get(DIRIGIBLE_RUNTIME_BRIDGE);
    }
}

