/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer;
import org.eclipse.dirigible.ide.db.viewer.views.ISQLConsole;
import org.eclipse.dirigible.ide.db.viewer.views.Messages;
import org.eclipse.dirigible.ide.db.viewer.views.format.ResultSetStringWriter;
import org.eclipse.dirigible.ide.editor.text.editor.AbstractTextEditorWidget;
import org.eclipse.dirigible.ide.editor.text.editor.EditorMode;
import org.eclipse.dirigible.repository.datasource.DataSources;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSQLConsole
extends ViewPart
implements ISQLConsole {
    private static final String EXECUTE_QUERY_STATEMENT = Messages.SQLConsole_EXECUTE_QUERY_STATEMENT;
    private static final String EXECUTE_QUERY = Messages.SQLConsole_EXECUTE_QUERY;
    private static final String EXECUTE_UPDATE_STATEMENT = Messages.SQLConsole_EXECUTE_UPDATE_STATEMENT;
    private static final String EXECUTE_UPDATE_TEXT = Messages.SQLConsole_EXECUTE_UPDATE_TEXT;
    private static final String EMPTY = "";
    private static final String ICON_EXECUTE_UPDATE_PNG = "icon-execute.png";
    private static final String ICON_EXECUTE_QUERY_PNG = "icon-execute.png";
    private static final String ICONS_SEGMENT = "/icons/";
    private static final String POPUP_MENU = "#PopupMenu";
    private static final String UPDATE_COUNT_S = Messages.SQLConsole_UPDATE_COUNT_S;
    private static final String EXECUTE_UPDATE = Messages.SQLConsole_EXECUTE_UPDATE;
    private static final Logger logger = Logger.getLogger(AbstractSQLConsole.class);
    public static final String ID = "org.eclipse.dirigible.ide.db.viewer.views.SQLConsole";
    private AbstractTextEditorWidget scriptArea = null;
    private Text outputArea = null;
    private Action actionExecuteUpdate;
    private Action actionExecuteQuery;
    public static final String SCRIPT_DELIMITER = ";";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ToolBar toolBar = new ToolBar(parent, 8521800);
        SashForm sashForm = new SashForm(parent, 2560);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptArea = this.createSQLEditorWidget(sashForm);
        this.scriptArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptArea.setText(EMPTY, this.getMode(), false, false, 0);
        this.outputArea = new Text((Composite)sashForm, 778);
        this.outputArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputArea.setText(EMPTY);
        this.outputArea.setFont(new Font(null, "Courier New", 12, 0));
        ToolItem itemQuery = new ToolItem(toolBar, 10);
        itemQuery.setText(EXECUTE_QUERY);
        Image iconQuery = ImageDescriptor.createFromURL((URL)AbstractSQLConsole.class.getResource("/icons/icon-execute.png")).createImage();
        itemQuery.setImage(iconQuery);
        itemQuery.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 1281159157504712273L;

            public void widgetSelected(SelectionEvent e) {
                AbstractSQLConsole.this.actionExecuteQuery.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boolean isOperator = CommonParameters.isUserInRole((String)"Operator");
        if (isOperator) {
            new ToolItem(toolBar, 2);
            ToolItem itemUpdate = new ToolItem(toolBar, 8);
            itemUpdate.setText(EXECUTE_UPDATE);
            Image iconUpdate = ImageDescriptor.createFromURL((URL)AbstractSQLConsole.class.getResource("/icons/icon-execute.png")).createImage();
            itemUpdate.setImage(iconUpdate);
            itemUpdate.addSelectionListener(new SelectionListener(){
                private static final long serialVersionUID = 1281159157504712273L;

                public void widgetSelected(SelectionEvent e) {
                    AbstractSQLConsole.this.actionExecuteUpdate.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.makeActions();
        this.hookContextMenu();
    }

    protected abstract AbstractTextEditorWidget createSQLEditorWidget(SashForm var1);

    public void setFocus() {
        this.scriptArea.setFocus();
    }

    private void makeActions() {
        this.actionExecuteQuery = new Action(){
            private static final long serialVersionUID = -4666336820729503841L;

            public void run() {
                AbstractSQLConsole.this.executeStatement(true);
            }
        };
        this.actionExecuteQuery.setText(EXECUTE_QUERY);
        this.actionExecuteQuery.setToolTipText(EXECUTE_QUERY_STATEMENT);
        this.actionExecuteUpdate = new Action(){
            private static final long serialVersionUID = -4666336820729503841L;

            public void run() {
                AbstractSQLConsole.this.executeStatement(false);
            }
        };
        this.actionExecuteUpdate.setText(EXECUTE_UPDATE_TEXT);
        this.actionExecuteUpdate.setToolTipText(EXECUTE_UPDATE_STATEMENT);
    }

    @Override
    public void executeStatement(boolean isQuery) {
        String sql = this.scriptArea.getText();
        if (sql == null || sql.length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(sql, SCRIPT_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (EMPTY.equals(line.trim())) continue;
            Connection conn = null;
            try {
                try {
                    conn = DatabaseViewer.getConnectionFromSelectedDatasource();
                    DataSources.executeSingleStatement((Connection)conn, (String)line, (boolean)isQuery, (DataSources.RequestExecutionCallback)new DataSources.RequestExecutionCallback(){

                        public void updateDone(int recordsCount) {
                            AbstractSQLConsole.this.printUpdateCount(recordsCount);
                        }

                        public void queryDone(ResultSet rs) {
                            try {
                                AbstractSQLConsole.this.printResultSet(rs);
                            }
                            catch (SQLException e) {
                                logger.warn(e.getMessage(), (Throwable)e);
                                AbstractSQLConsole.this.outputArea.setText(e.getMessage());
                            }
                        }

                        public void error(Throwable t) {
                            logger.warn(t.getMessage(), t);
                            AbstractSQLConsole.this.outputArea.setText(t.getMessage());
                        }
                    });
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    this.outputArea.setText(e.getMessage());
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        logger.warn(e2.getMessage(), (Throwable)e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Connection getConnection() throws Exception {
        return DatabaseViewer.getConnectionFromSelectedDatasource();
    }

    protected void printResultSet(ResultSet resultSet) throws SQLException {
        ResultSetStringWriter writer = new ResultSetStringWriter();
        String tableString = writer.writeTable(resultSet);
        this.outputArea.setText(tableString);
    }

    protected void printUpdateCount(int updateCount) {
        this.outputArea.setText(String.format(UPDATE_COUNT_S, updateCount));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(POPUP_MENU);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = 7417283863427269417L;

            public void menuAboutToShow(IMenuManager manager) {
                AbstractSQLConsole.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.scriptArea);
        this.scriptArea.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExecuteUpdate);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    public void setQuery(String query) {
        this.scriptArea.setText(query, this.getMode(), false, false, 0);
    }

    private EditorMode getMode() {
        return EditorMode.SQL;
    }
}

