/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common.status;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dirigible.ide.common.status.Messages;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class StatusLineManagerUtil {
    private static final String PLUGIN_ID = "org.eclipse.dirigible.ide.common";
    private static final String CLEAR_MESSAGES_JOB = "Clear Messages Job";
    private static final int CLEAR_MESSAGE_JOB_DELAY = 10000;
    public static final String ARTIFACT_HAS_BEEN_CREATED = Messages.StatusLineManagerUtil_ARTIFACT_HAS_BEEN_CREATED;
    public static final String ARTIFACT_HAS_BEEN_ACTIVATED = Messages.StatusLineManagerUtil_ARTIFACT_HAS_BEEN_ACTIVATED;
    public static final String ARTIFACT_HAS_BEEN_PUBLISHED = Messages.StatusLineManagerUtil_ARTIFACT_HAS_BEEN_PUBLISHED;

    public static IStatusLineManager getDefaultStatusLineManager() {
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        Object statusLineManager = workbenchPart instanceof IViewPart ? ((IViewPart)workbenchPart).getViewSite().getActionBars().getStatusLineManager() : (workbenchPart instanceof IEditorPart ? ((IEditorPart)workbenchPart).getEditorSite().getActionBars().getStatusLineManager() : new StatusLineManager());
        return statusLineManager;
    }

    public static void clearMessages() {
        UIJob job = new UIJob(CLEAR_MESSAGES_JOB){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatusLineManager statusLineManager = StatusLineManagerUtil.getDefaultStatusLineManager();
                statusLineManager.removeAll();
                statusLineManager.setMessage(null, null);
                statusLineManager.setErrorMessage(null, null);
                return new Status(0, StatusLineManagerUtil.PLUGIN_ID, "");
            }
        };
        job.schedule(10000L);
    }

    public static void setInfoMessage(String message) {
        StatusLineManagerUtil.getDefaultStatusLineManager().removeAll();
        StatusLineManagerUtil.getDefaultStatusLineManager().setMessage(JFaceResources.getImage((String)"dialog_messasge_info_image"), message);
        StatusLineManagerUtil.clearMessages();
    }

    public static void setErrorMessage(String message) {
        StatusLineManagerUtil.getDefaultStatusLineManager().removeAll();
        StatusLineManagerUtil.getDefaultStatusLineManager().setErrorMessage(JFaceResources.getImage((String)"dialog_message_error_image"), message);
        StatusLineManagerUtil.clearMessages();
    }

    public static void setWarningMessage(String message) {
        StatusLineManagerUtil.getDefaultStatusLineManager().removeAll();
        StatusLineManagerUtil.getDefaultStatusLineManager().setMessage(JFaceResources.getImage((String)"dialog_messasge_warning_image"), message);
        StatusLineManagerUtil.clearMessages();
    }

    private StatusLineManagerUtil() {
    }
}

