/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;
import org.eclipse.dirigible.runtime.content.ContentImporterServlet;
import org.eclipse.dirigible.runtime.content.ContentResetMaker;

public class CloneImporterServlet
extends ContentImporterServlet {
    private static final long serialVersionUID = -7275411031828315889L;
    private static final Logger logger = Logger.getLogger(CloneImporterServlet.class);
    private static final String CLONE_PATH_FOR_IMPORT = "/db/".substring(0, "/db/".length() - 1);
    private static final String PARAMETER_RESET = "reset";
    private static final String HEADER_RESET = "reset";

    @Override
    protected String getDefaultPathForImport() {
        return CLONE_PATH_FOR_IMPORT;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean reset;
        if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
            String err = String.format("%s called, but the user does not have permissions to do this operation", "Import Cloned Content");
            logger.error(err);
            throw new ServletException(err);
        }
        boolean bl = reset = Boolean.parseBoolean(request.getParameter("reset")) || Boolean.parseBoolean(request.getHeader("reset"));
        if (reset) {
            IRepository repository = this.getRepository(request);
            ContentResetMaker resetMaker = new ContentResetMaker();
            resetMaker.doReset(request, repository);
        }
        super.doPost(request, response);
    }
}

