/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class TemplateCommandHandler
extends AbstractWorkspaceHandler {
    private static final String COULD_NOT_OPEN_WIZARD = Messages.TemplateCommandHandler_COULD_NOT_OPEN_WIZARD;
    private static final String OPEN_WIZARD_ERROR = Messages.TemplateCommandHandler_OPEN_WIZARD_ERROR;
    private static final Logger logger = Logger.getLogger(TemplateCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object lastSelectedElement;
        ISelection selection = null;
        if (event != null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (selection == null && (lastSelectedElement = this.getLastSelectedWorkspaceElement()) != null && lastSelectedElement instanceof IResource) {
            this.openWizard((IResource)lastSelectedElement);
            return null;
        }
        this.openWizard(selection);
        return null;
    }

    private void openWizard(ISelection selection) {
        Object element;
        IResource resource = null;
        if (selection != null && IStructuredSelection.class.isInstance(selection) && IResource.class.isInstance(element = ((IStructuredSelection)selection).getFirstElement())) {
            resource = (IResource)element;
        }
        this.openWizard(resource);
    }

    protected void openWizard(IResource resource) {
        try {
            Wizard wizard = this.getWizard(resource);
            WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
            dialog.open();
        }
        catch (Exception ex) {
            logger.error(COULD_NOT_OPEN_WIZARD, (Throwable)ex);
            MessageDialog.openError(null, (String)OPEN_WIZARD_ERROR, (String)ex.getMessage());
        }
    }

    protected abstract Wizard getWizard(IResource var1);
}

