/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.security.publish;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.ext.security.SecurityUpdater;
import org.eclipse.dirigible.repository.logging.Logger;

public class SecurityPublisher
extends AbstractPublisher
implements IPublisher {
    private static final Logger logger = Logger.getLogger(SecurityPublisher.class);

    public void publish(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(project, this.getRegistryLocation());
            IFolder sourceFolder = this.getSourceFolder(project, "SecurityConstraints");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
            ArrayList knownFiles = new ArrayList();
            SecurityUpdater securityUpdater = new SecurityUpdater(RepositoryFacade.getInstance().getRepository(), DataSourceFacade.getInstance().getDataSource(), this.getRegistryLocation());
            ICollection sourceProjectContainer = this.getSourceProjectContainer(project);
            ICollection sourceContainer = sourceProjectContainer.getCollection("SecurityConstraints");
            securityUpdater.enumerateKnownFiles(sourceContainer, knownFiles);
            ArrayList errors = new ArrayList();
            securityUpdater.executeUpdate(knownFiles, CommonParameters.getRequest(), errors);
            if (errors.size() > 0) {
                throw new PublishException(CommonUtils.concatenateListOfStrings(errors, (String)"\n"));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project) throws PublishException {
        this.publish(project);
    }

    public void activateFile(IFile file) throws PublishException {
        this.publish(file.getProject());
    }

    public String getFolderType() {
        return "SecurityConstraints";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && ".access".equals("." + file.getFileExtension());
    }

    public String getPublishedContainerMapping(IFile file) {
        return null;
    }

    public String getActivatedContainerMapping(IFile file) {
        return null;
    }

    public boolean isAutoActivationAllowed() {
        return false;
    }

    protected String getSandboxLocation() {
        return null;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/SecurityConstraints";
    }
}

