/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.RequestMessage;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.WrappedRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlParameters {
    public static final String PARAM_CONNECTION_ID = "cid";

    static void merge(RequestMessage requestMessage) {
        Map<String, String[]> parameters;
        if (UrlParameters.hasInitializeParameter(requestMessage) && (parameters = UrlParameters.getAll(requestMessage)) != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            WrappedRequest wrappedRequest = new WrappedRequest(request, parameters);
            ServiceContext context = ContextProvider.getContext();
            context.setRequest((HttpServletRequest)wrappedRequest);
        }
    }

    private static Map<String, String[]> getAll(RequestMessage requestMessage) {
        JsonValue queryStringHeader = requestMessage.getHead().get("queryString");
        return queryStringHeader == null ? null : UrlParameters.createParametersMap(queryStringHeader.asString());
    }

    static Map<String, String[]> createParametersMap(String queryString) {
        String[] parameters;
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String[] stringArray = parameters = queryString.split("&");
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            String[] parts = parameter.split("=");
            try {
                String name = URLDecoder.decode(parts[0], "UTF-8");
                String value = parts.length == 1 ? "" : URLDecoder.decode(parts[1], "UTF-8");
                String[] oldValues = (String[])result.get(name);
                result.put(name, UrlParameters.appendValue(oldValues, value));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            ++n2;
        }
        return result;
    }

    private static String[] appendValue(String[] oldValues, String newValue) {
        String[] result = null;
        if (oldValues == null) {
            result = new String[]{newValue};
        } else {
            result = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, result, 0, oldValues.length);
            result[result.length - 1] = newValue;
        }
        return result;
    }

    private static boolean hasInitializeParameter(RequestMessage requestMessage) {
        return JsonValue.TRUE.equals(requestMessage.getHead().get("rwt_initialize"));
    }

    private UrlParameters() {
    }
}

