/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.basequery;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.AtomicExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CompositeExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.ColumnValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CombinedValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.NestedValueExpression;

public class CombinedQuery
extends BaseQuery {
    private CombinedType m_combinedType;
    private QuerySpecification m_leftQuery;
    private QuerySpecification m_rightQuery;
    private CombinedQueryCondition m_combinedCondition;

    public CombinedQuery() {
        this(CombinedType.INNER_JOIN);
    }

    public CombinedQuery(CombinedType combinedType) {
        this.m_combinedType = combinedType;
    }

    public void setCombinedQuery(QuerySpecification leftQuery, QuerySpecification rightQuery, CombinedQueryCondition combinedCondition) throws OdaException {
        this.m_leftQuery = leftQuery;
        this.m_rightQuery = rightQuery;
        this.m_combinedCondition = combinedCondition;
        this.validateSyntax(null);
    }

    public QuerySpecification getLeftQuery() {
        return this.m_leftQuery;
    }

    public QuerySpecification getRightQuery() {
        return this.m_rightQuery;
    }

    public CombinedType getCombinedType() {
        return this.m_combinedType;
    }

    public CombinedQueryCondition getCombinedCondition() {
        return this.m_combinedCondition;
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        if (this.m_leftQuery == null || this.m_rightQuery == null || this.m_combinedCondition == null) {
            throw ValidatorUtil.newBaseQueryException(Messages.querySpec_INCOMPLETE_COMBINED_QUERY, this);
        }
        try {
            this.m_combinedCondition.validateSyntax(context);
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newBaseQueryException(this, ex);
        }
    }

    private void validateCombiningExpression(FilterExpression combiningExpr) throws OdaException {
        if (combiningExpr instanceof AtomicExpression) {
            AtomicExpression atomicCombiningExpr = (AtomicExpression)combiningExpr;
            this.validateQueryQualifier(atomicCombiningExpr.getVariable().getValueExpression());
            int numArgs = atomicCombiningExpr.getArguments().valueCount();
            int i = 0;
            while (i < numArgs) {
                this.validateQueryQualifier(atomicCombiningExpr.getArguments().getValueExpression(i));
                ++i;
            }
            return;
        }
        if (combiningExpr instanceof CompositeExpression) {
            FilterExpression[] childExprs = ((CompositeExpression)combiningExpr).getChildren();
            int i = 0;
            while (i < childExprs.length) {
                this.validateCombiningExpression(childExprs[i]);
                ++i;
            }
            return;
        }
    }

    private void validateQueryQualifier(ValueExpression valueExpr) throws OdaException {
        ColumnIdentifier columnIdentifier;
        if (valueExpr instanceof ColumnValueExpression && (columnIdentifier = ((ColumnValueExpression)valueExpr).getColumnReference()) != null) {
            QuerySpecification columnQuerySpec = columnIdentifier.getQueryQualifier();
            if (columnQuerySpec != null && !this.containsCombiningQuery(columnQuerySpec)) {
                throw ValidatorUtil.newValueExprException(Messages.bind((String)Messages.querySpec_NON_RELATED_QUERYSPEC, (Object)columnIdentifier), valueExpr);
            }
            return;
        }
        if (valueExpr instanceof NestedValueExpression) {
            this.validateQueryQualifier(((NestedValueExpression)valueExpr).getNestedExpression());
            return;
        }
        if (valueExpr instanceof CombinedValueExpression) {
            this.validateQueryQualifier(((CombinedValueExpression)valueExpr).getLeftExpression());
            this.validateQueryQualifier(((CombinedValueExpression)valueExpr).getRightExpression());
            return;
        }
    }

    private boolean containsCombiningQuery(QuerySpecification querySpec) {
        CombinedQuery nestedCombinedQuery;
        if (querySpec == this.getLeftQuery()) {
            return true;
        }
        if (querySpec == this.getRightQuery()) {
            return true;
        }
        if (this.getLeftQuery().getBaseQuery() instanceof CombinedQuery && (nestedCombinedQuery = (CombinedQuery)this.getLeftQuery().getBaseQuery()) != this && nestedCombinedQuery.containsCombiningQuery(querySpec)) {
            return true;
        }
        return this.getRightQuery().getBaseQuery() instanceof CombinedQuery && (nestedCombinedQuery = (CombinedQuery)this.getRightQuery().getBaseQuery()) != this && nestedCombinedQuery.containsCombiningQuery(querySpec);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(CombinedQuery.class.getSimpleName());
        buffer.append(" ");
        buffer.append(this.m_combinedType.name());
        buffer.append("\n    { leftQuery: ");
        buffer.append(this.m_leftQuery);
        buffer.append(" }\n    { rightQuery: ");
        buffer.append(this.m_rightQuery);
        buffer.append(" }\n    { combinedQueryCondition: ");
        buffer.append(this.m_combinedCondition);
        buffer.append(" }");
        return buffer.toString();
    }

    public CombinedQueryCondition createCombinedCondition(FilterExpression combinedExpr) {
        CombinedQuery combinedQuery = this;
        combinedQuery.getClass();
        return combinedQuery.new CombinedQueryCondition(combinedExpr);
    }

    public class CombinedQueryCondition {
        private FilterExpression m_expr;

        CombinedQueryCondition(FilterExpression combiningExpr) {
            this.m_expr = combiningExpr;
        }

        public FilterExpression getCombiningExpression() {
            return this.m_expr;
        }

        public void validate() throws OdaException {
            this.validate(null);
        }

        public void validate(ValidationContext context) throws OdaException {
            this.validateSyntax(context);
            this.m_expr.validate(context);
        }

        public void validateSyntax(ValidationContext context) throws OdaException {
            if (this.m_expr == null) {
                throw new OdaException(Messages.querySpec_MISSING_COMBINED_MATCHING_EXPR);
            }
            this.m_expr.validateSyntax(context);
            CombinedQuery.this.validateCombiningExpression(this.m_expr);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(" { combining expr: ");
            buffer.append(this.m_expr);
            buffer.append(" }");
            return buffer.toString();
        }
    }

    public static enum CombinedType {
        INNER_JOIN,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }
}

