/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpTopic;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.CtxHelpTreeSection;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details.CtxHelpDetailsMessages;
import org.eclipse.pde.internal.ua.ui.editor.toc.details.HelpEditorFilter;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CtxHelpTopicDetails
extends CtxHelpAbstractDetails {
    private CtxHelpTopic fTopic;
    private FormEntry fLabelEntry;
    private FormEntry fLinkEntry;

    public CtxHelpTopicDetails(CtxHelpTreeSection masterSection) {
        super(masterSection, "ctxhelp-context");
    }

    @Override
    public void createFields(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpTopicDetails_label);
        this.fLabelEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpTopicDetails_location, 0);
        this.createSpace(parent);
        this.createLabel(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpTopicDetails_locationHTML);
        this.fLinkEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), CtxHelpDetailsMessages.CtxHelpTopicDetails_locationTitle, CtxHelpDetailsMessages.CtxHelpTopicDetails_browseTitle, this.isEditable());
    }

    @Override
    protected String getDetailsTitle() {
        return CtxHelpDetailsMessages.CtxHelpTopicDetails_detailsTitle;
    }

    @Override
    protected String getDetailsDescription() {
        return null;
    }

    @Override
    public void hookListeners() {
        this.fLabelEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpTopicDetails.this.fTopic != null) {
                    CtxHelpTopicDetails.this.fTopic.setLabel(CtxHelpTopicDetails.this.fLabelEntry.getValue());
                }
            }
        });
        this.fLinkEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CtxHelpTopicDetails.this.fTopic != null) {
                    CtxHelpTopicDetails.this.fTopic.setLocation((IPath)new Path(CtxHelpTopicDetails.this.fLinkEntry.getValue()));
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                CtxHelpTopicDetails.this.handleBrowse();
            }

            public void linkActivated(HyperlinkEvent e) {
                CtxHelpTopicDetails.this.handleOpen();
            }
        });
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(CtxHelpDetailsMessages.CtxHelpTopicDetails_dialogTitle);
        dialog.setMessage(CtxHelpDetailsMessages.CtxHelpTopicDetails_dialogMessage);
        dialog.addFilter((ViewerFilter)new HelpEditorFilter());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.setPathEntry(file);
        }
    }

    @Override
    public void updateFields() {
        if (this.fTopic != null) {
            this.fLabelEntry.setValue(this.fTopic.getLabel(), true);
            this.fLabelEntry.setEditable(this.isEditableElement());
            if (this.fTopic.getLocation() == null) {
                this.fLinkEntry.setValue("", true);
            } else {
                this.fLinkEntry.setValue(this.fTopic.getLocation().toPortableString(), true);
            }
            this.fLinkEntry.setEditable(this.isEditableElement());
        }
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fLabelEntry.commit();
        this.fLinkEntry.commit();
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object instanceof CtxHelpTopic) {
            this.fTopic = (CtxHelpTopic)object;
            this.updateFields();
        }
    }

    protected void setPathEntry(IFile file) {
        IPath path = file.getFullPath();
        if (file.getProject().equals((Object)this.fTopic.getModel().getUnderlyingResource().getProject())) {
            this.fLinkEntry.setValue(path.removeFirstSegments(1).toString());
        } else {
            this.fLinkEntry.setValue(".." + path.toString());
        }
    }

    protected void handleOpen() {
        this.getMasterSection().open(this.fTopic);
    }
}

