/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseFunction<T extends Comparable<? super T>, V>
implements Function<T, V> {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<Predicate<? super T>, Function<? super T, ? extends V>>> predicateFunctions = Lists.mutable.empty();
    private Function<? super T, ? extends V> defaultFunction;

    public CaseFunction() {
    }

    public CaseFunction(Function<? super T, ? extends V> newDefaultFunction) {
        this.defaultFunction = newDefaultFunction;
    }

    public CaseFunction<T, V> addCase(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        this.predicateFunctions.add(Tuples.pair(predicate, function));
        return this;
    }

    public CaseFunction<T, V> setDefault(Function<? super T, ? extends V> function) {
        this.defaultFunction = function;
        return this;
    }

    public V valueOf(T argument) {
        for (Pair pair : this.predicateFunctions) {
            if (!((Predicate)pair.getOne()).accept(argument)) continue;
            return (V)((Function)pair.getTwo()).valueOf(argument);
        }
        if (this.defaultFunction != null) {
            return (V)this.defaultFunction.valueOf(argument);
        }
        return null;
    }

    public String toString() {
        return "new CaseFunction(" + this.predicateFunctions + ')';
    }
}

