/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectCharIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyCharIterate {
    private static final LazyCharIterable EMPTY_ITERABLE = CharLists.immutable.of().asLazy();

    private LazyCharIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyCharIterable adapt(CharIterable iterable) {
        return new LazyCharIterableAdapter(iterable);
    }

    public static LazyCharIterable select(CharIterable iterable, CharPredicate predicate) {
        return new SelectCharIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(CharIterable iterable, CharToObjectFunction<? extends V> function) {
        return new CollectCharToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(CharIterable iterable, CharPredicate predicate, CharToObjectFunction<? extends V> function) {
        return LazyCharIterate.select(iterable, predicate).collect(function);
    }

    public static LazyCharIterable empty() {
        return EMPTY_ITERABLE;
    }
}

