/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.resolved;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.resolved.ResolvedLocation;
import org.eclipse.cbi.targetplatform.resolved.UnresolvedIU;
import org.eclipse.cbi.targetplatform.util.LocationIndexBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class ResolvedTargetPlatform {
    private final List<ResolvedLocation> locations;
    private final String name;
    private final EnumSet<Option> options;
    private final Environment environment;

    public ResolvedTargetPlatform(String name, List<ResolvedLocation> locations, EnumSet<Option> options, Environment environment) {
        this.name = name;
        this.locations = locations;
        this.options = options;
        this.environment = environment;
    }

    public List<ResolvedLocation> getLocations() {
        return this.locations;
    }

    public String getName() {
        return this.name;
    }

    public EnumSet<Option> getOptions() {
        return this.options;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Diagnostic resolve(IMetadataRepositoryManager metadataRepositoryManager, IProgressMonitor monitor) {
        BasicDiagnostic ret = new BasicDiagnostic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getLocations().size());
        for (ResolvedLocation location : this.getLocations()) {
            if (subMonitor.isCanceled()) {
                ret.merge(BasicDiagnostic.CANCEL_INSTANCE);
                break;
            }
            Diagnostic diagnostic = location.resolve(metadataRepositoryManager, (IProgressMonitor)subMonitor);
            if (diagnostic.getSeverity() >= 2) {
                ret.merge(diagnostic);
            }
            subMonitor.worked(1);
        }
        return ret;
    }

    public static ResolvedTargetPlatform create(TargetPlatform targetPlatform, LocationIndexBuilder indexBuilder) throws URISyntaxException {
        Preconditions.checkArgument((targetPlatform != null ? 1 : 0) != 0);
        LinkedList locations = Lists.newLinkedList();
        ListMultimap<String, Location> locationIndex = indexBuilder.getLocationIndex(targetPlatform);
        for (String locationUri : locationIndex.keySet()) {
            ArrayList ius = Lists.newArrayList();
            HashSet ids = Sets.newHashSet();
            List list = locationIndex.get((Object)locationUri);
            for (Location location : list) {
                EList iuList = location.getIus();
                for (IU iu : iuList) {
                    if (ids.contains(iu.getID())) continue;
                    ids.add(iu.getID());
                    ius.add(new UnresolvedIU(iu.getID(), Strings.emptyToNull((String)iu.getVersion())));
                }
            }
            Location firstLocation = (Location)locationIndex.get((Object)locationUri).get(0);
            ResolvedLocation resolvedLocation = new ResolvedLocation(firstLocation.getID(), firstLocation.getUri(), (List<UnresolvedIU>)ius, ResolvedTargetPlatform.getOptionSet((EList<Option>)firstLocation.getOptions()));
            locations.addFirst(resolvedLocation);
        }
        EnumSet<Option> options = ResolvedTargetPlatform.getOptionSet((EList<Option>)targetPlatform.getOptions());
        return new ResolvedTargetPlatform(targetPlatform.getName(), locations, options, Environment.create(targetPlatform));
    }

    public static EnumSet<Option> getOptionSet(EList<Option> optionsList) {
        EnumSet<Option> optionSet = optionsList.isEmpty() ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(optionsList);
        return optionSet;
    }

    public static class Environment {
        private final String os;
        private final String ws;
        private final String arch;
        private final String nl;
        private final String targetJRE;

        public Environment(String os, String ws, String arch, String nl, String targetJRE) {
            this.os = os;
            this.ws = ws;
            this.arch = arch;
            this.nl = nl;
            this.targetJRE = targetJRE;
        }

        public static Environment create(TargetPlatform targetPlatform) {
            org.eclipse.cbi.targetplatform.model.Environment env = targetPlatform.getEnvironment();
            if (env != null) {
                IPath path;
                String os = Strings.emptyToNull((String)env.getOperatingSystem());
                String ws = Strings.emptyToNull((String)env.getWindowingSystem());
                String arch = Strings.emptyToNull((String)env.getArchitecture());
                String nl = env.getLocalization() != null ? env.getLocalization().toString() : null;
                String jrePath = env.getExecutionEnvironment() != null ? ((path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env.getExecutionEnvironment())) != null ? path.toString() : null) : null;
                return new Environment(os, ws, arch, nl, jrePath);
            }
            return null;
        }

        public String getOs() {
            return this.os;
        }

        public String getWs() {
            return this.ws;
        }

        public String getArch() {
            return this.arch;
        }

        public String getNl() {
            return this.nl;
        }

        public String getTargetJRE() {
            return this.targetJRE;
        }
    }
}

