/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.ju.testCases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.impl.PartImpl;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.mass.helpers.MassCreationToolHelper;
import org.polarsys.capella.vp.mass.mass.impl.PartMassImpl;

public abstract class MassTest
extends BasicTestCase {
    protected PhysicalComponent physicalSystem;
    public static final String MODEL_NAME = "MassProject";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    protected void setUp() throws Exception {
        Job[] allJobs;
        super.setUp();
        Job[] jobArray = allJobs = Job.getJobManager().find(null);
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if ("Workbench Auto-Save Job".equals(job.getName())) {
                job.cancel();
            }
            ++n2;
        }
        this.physicalSystem = this.getPhysicalSystem();
    }

    protected PhysicalComponent getPhysicalSystem() {
        CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        Project project = model.getProject(session.getTransactionalEditingDomain());
        SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(0);
        PhysicalArchitecture physicalArchi = (PhysicalArchitecture)eng.getOwnedArchitectures().get(3);
        PhysicalComponentPkg physicalComponentPkg = physicalArchi.getOwnedPhysicalComponentPkg();
        return (PhysicalComponent)physicalComponentPkg.getOwnedPhysicalComponents().get(0);
    }

    protected void addMassToPhysicalComponent(final PhysicalComponent element, final int massValue) {
        ExecutionManager manager = TransactionHelper.getExecutionManager((EObject)element);
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                MassCreationToolHelper massCreationToolHelper = new MassCreationToolHelper();
                massCreationToolHelper.createMass((EObject)element, 1);
                PartMassImpl elementPartMass = (PartMassImpl)((PartImpl)element.getAbstractTypedElements().get(0)).getOwnedExtensions().get(0);
                elementPartMass.setValue(massValue);
            }
        });
    }

    protected void editMassPhysicalComponent(PhysicalComponent element, final int newMass) {
        final PartMassImpl pcPartMass = (PartMassImpl)((PartImpl)element.getAbstractTypedElements().get(0)).getOwnedExtensions().get(0);
        ExecutionManager managerpc = TransactionHelper.getExecutionManager((EObject)element);
        managerpc.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                pcPartMass.setValue(newMass);
            }
        });
    }
}

