/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.ui.internal.view.task.BaseProjectNode;
import org.eclipse.buildship.ui.internal.view.task.BuildInvocations;
import org.eclipse.core.resources.IProject;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class ProjectNode
extends BaseProjectNode {
    private final ProjectNode parentProjectNode;
    private final EclipseProject eclipseProject;
    private final GradleProject gradleProject;
    private final boolean includedProject;
    private final Map<Path, BuildInvocations> allBuildInvocations;
    private final Path projectPath;

    public ProjectNode(ProjectNode parentProjectNode, EclipseProject eclipseProject, GradleProject gradleProject, Optional<IProject> workspaceProject, boolean includedProject, Map<Path, BuildInvocations> allBuildInvocations, Path projectPath) {
        super(workspaceProject);
        this.parentProjectNode = parentProjectNode;
        this.eclipseProject = (EclipseProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (GradleProject)Preconditions.checkNotNull((Object)gradleProject);
        this.includedProject = includedProject;
        this.allBuildInvocations = (Map)Preconditions.checkNotNull(allBuildInvocations);
        this.projectPath = (Path)Preconditions.checkNotNull((Object)projectPath);
    }

    public String getDisplayName() {
        Optional<IProject> workspaceProject = this.getWorkspaceProject();
        String name = workspaceProject.isPresent() ? ((IProject)workspaceProject.get()).getName() : this.getEclipseProject().getName();
        return name;
    }

    public ProjectNode getRootProjectNode() {
        ProjectNode root = this;
        while (root.getParentProjectNode() != null) {
            root = root.getParentProjectNode();
        }
        return root;
    }

    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    public EclipseProject getEclipseProject() {
        return this.eclipseProject;
    }

    public GradleProject getGradleProject() {
        return this.gradleProject;
    }

    public boolean isIncludedProject() {
        return this.includedProject;
    }

    public Map<Path, BuildInvocations> getAllBuildInvocations() {
        return ImmutableMap.copyOf(this.allBuildInvocations);
    }

    public BuildInvocations getInvocations() {
        return this.allBuildInvocations.get(this.projectPath);
    }

    public String toString() {
        return this.gradleProject.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectNode that = (ProjectNode)other;
        return Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.eclipseProject, (Object)that.eclipseProject) && Objects.equal((Object)this.gradleProject, (Object)that.gradleProject) && Objects.equal((Object)this.includedProject, (Object)that.includedProject) && Objects.equal(this.allBuildInvocations, that.allBuildInvocations) && Objects.equal((Object)this.projectPath, (Object)that.projectPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getWorkspaceProject(), this.parentProjectNode, this.eclipseProject, this.gradleProject, this.includedProject, this.allBuildInvocations, this.projectPath});
    }
}

