/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaCompositor;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XSDUtils {
    private static List<XSDSimpleTypeDefinition> primitives;
    private static List<XSDTypeDefinition> advancedPrimitives;
    private static List<String> xsdShortList;
    private static List<String> supportedPrimitives;

    static {
        xsdShortList = new ArrayList<String>();
        xsdShortList.add("string");
        xsdShortList.add("int");
        xsdShortList.add("double");
        xsdShortList.add("date");
        xsdShortList.add("time");
        xsdShortList.add("dateTime");
        xsdShortList.add("boolean");
        xsdShortList.add("hexBinary");
        xsdShortList.add("float");
        supportedPrimitives = new ArrayList<String>();
        supportedPrimitives.add("anyType");
        supportedPrimitives.add("anyURI");
        supportedPrimitives.add("base64Binary");
        supportedPrimitives.add("boolean");
        supportedPrimitives.add("byte");
        supportedPrimitives.add("date");
        supportedPrimitives.add("dateTime");
        supportedPrimitives.add("decimal");
        supportedPrimitives.add("double");
        supportedPrimitives.add("duration");
        supportedPrimitives.add("ENTITIES");
        supportedPrimitives.add("ENTITY");
        supportedPrimitives.add("float");
        supportedPrimitives.add("gDay");
        supportedPrimitives.add("gMonth");
        supportedPrimitives.add("gMonthDay");
        supportedPrimitives.add("gYear");
        supportedPrimitives.add("gYearMonth");
        supportedPrimitives.add("hexBinary");
        supportedPrimitives.add("ID");
        supportedPrimitives.add("IDREF");
        supportedPrimitives.add("IDREFS");
        supportedPrimitives.add("int");
        supportedPrimitives.add("integer");
        supportedPrimitives.add("language");
        supportedPrimitives.add("long");
        supportedPrimitives.add("Name");
        supportedPrimitives.add("NCName");
        supportedPrimitives.add("negativeInteger");
        supportedPrimitives.add("NMTOKEN");
        supportedPrimitives.add("NMTOKENS");
        supportedPrimitives.add("nonNegativeInteger");
        supportedPrimitives.add("nonPositiveInteger");
        supportedPrimitives.add("normalizedString");
        supportedPrimitives.add("NOTATION");
        supportedPrimitives.add("positiveInteger");
        supportedPrimitives.add("QName");
        supportedPrimitives.add("short");
        supportedPrimitives.add("string");
        supportedPrimitives.add("time");
        supportedPrimitives.add("token");
        supportedPrimitives.add("unsignedByte");
        supportedPrimitives.add("unsignedInt");
        supportedPrimitives.add("unsignedLong");
        supportedPrimitives.add("unsignedShort");
    }

    public static XSDAnnotation addDocumentation(XSDConcreteComponent component, String text) {
        if (component == null) {
            throw new IllegalArgumentException("addDocumentation called with null component");
        }
        try {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDAnnotation xsdAnnotation = xsdFactory.createXSDAnnotation();
            if (component instanceof XSDAttributeDeclaration) {
                if (((XSDAttributeDeclaration)component).getAnnotation() == null) {
                    ((XSDAttributeDeclaration)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDAttributeDeclaration)component).getAnnotation();
                }
            } else if (component instanceof XSDAttributeGroupDefinition) {
                if (((XSDAttributeGroupDefinition)component).getAnnotation() == null) {
                    ((XSDAttributeGroupDefinition)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDAttributeGroupDefinition)component).getAnnotation();
                }
            } else if (component instanceof XSDElementDeclaration) {
                if (((XSDElementDeclaration)component).getAnnotation() == null) {
                    ((XSDElementDeclaration)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDElementDeclaration)component).getAnnotation();
                }
            } else if (component instanceof XSDFacet) {
                if (((XSDFacet)component).getAnnotation() == null) {
                    ((XSDFacet)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDFacet)component).getAnnotation();
                }
            } else if (component instanceof XSDIdentityConstraintDefinition) {
                if (((XSDIdentityConstraintDefinition)component).getAnnotation() == null) {
                    ((XSDIdentityConstraintDefinition)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDIdentityConstraintDefinition)component).getAnnotation();
                }
            } else if (component instanceof XSDImport) {
                if (((XSDImport)component).getAnnotation() == null) {
                    ((XSDImport)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDImport)component).getAnnotation();
                }
            } else if (component instanceof XSDInclude) {
                if (((XSDInclude)component).getAnnotation() == null) {
                    ((XSDInclude)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDInclude)component).getAnnotation();
                }
            } else if (component instanceof XSDModelGroup) {
                if (((XSDModelGroup)component).getAnnotation() == null) {
                    ((XSDModelGroup)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDModelGroup)component).getAnnotation();
                }
            } else if (component instanceof XSDModelGroupDefinition) {
                if (((XSDModelGroupDefinition)component).getAnnotation() == null) {
                    ((XSDModelGroupDefinition)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDModelGroupDefinition)component).getAnnotation();
                }
            } else if (component instanceof XSDNotationDeclaration) {
                if (((XSDNotationDeclaration)component).getAnnotation() == null) {
                    ((XSDNotationDeclaration)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDNotationDeclaration)component).getAnnotation();
                }
            } else if (component instanceof XSDTypeDefinition) {
                if (((XSDTypeDefinition)component).getAnnotation() == null) {
                    ((XSDTypeDefinition)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDTypeDefinition)component).getAnnotation();
                }
            } else if (component instanceof XSDWildcard) {
                if (((XSDWildcard)component).getAnnotation() == null) {
                    ((XSDWildcard)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDWildcard)component).getAnnotation();
                }
            } else if (component instanceof XSDXPathDefinition) {
                if (((XSDXPathDefinition)component).getAnnotation() == null) {
                    ((XSDXPathDefinition)component).setAnnotation(xsdAnnotation);
                } else {
                    xsdAnnotation = ((XSDXPathDefinition)component).getAnnotation();
                }
            } else if (component instanceof XSDSchema) {
                ((XSDSchema)component).getContents().add((Object)xsdAnnotation);
            } else {
                throw new IllegalArgumentException("Unable to addDocumentation onto type: " + component);
            }
            int i = 0;
            while (i < xsdAnnotation.getElement().getChildNodes().getLength()) {
                Node node = xsdAnnotation.getElement().getChildNodes().item(i);
                if (node.getNodeName().endsWith("documentation")) {
                    xsdAnnotation.getElement().removeChild(node);
                }
                ++i;
            }
            xsdAnnotation.getUserInformation().clear();
            if (text != null) {
                Element userInfo = xsdAnnotation.createUserInformation(null);
                userInfo.appendChild(userInfo.getOwnerDocument().createTextNode(text));
                xsdAnnotation.getElement().appendChild(userInfo);
                xsdAnnotation.getUserInformation().add((Object)userInfo);
            }
            return xsdAnnotation;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XSDAnnotation addDocumentationAndAttributes(XSDConcreteComponent component, String text, Map attributes) {
        if (component == null) {
            throw new IllegalArgumentException("addDocumentationAndAttributes called with null component");
        }
        if (text == null && attributes == null) {
            return null;
        }
        XSDAnnotation annotation = XSDUtils.addDocumentation(component, text);
        if (annotation == null) {
            return null;
        }
        if (attributes == null || attributes.isEmpty()) {
            return annotation;
        }
        Element userInfo2 = null;
        if (annotation.getUserInformation().isEmpty()) {
            userInfo2 = annotation.createUserInformation(null);
            annotation.getElement().appendChild(userInfo2);
        } else {
            for (Element userInfo2 : annotation.getUserInformation()) {
                if (userInfo2.getTagName().endsWith("documentation")) break;
            }
        }
        if (userInfo2 == null) {
            return null;
        }
        String key2 = null;
        for (String key2 : attributes.keySet()) {
            userInfo2.setAttribute(key2, (String)attributes.get(key2));
        }
        return annotation;
    }

    public static String createUniqueElementName(String prefix, List elements) {
        ArrayList<String> usedNames = new ArrayList<String>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            usedNames.add(XSDUtils.getDisplayName((XSDNamedComponent)i.next()));
        }
        int i2 = 1;
        String testName = String.valueOf(prefix) + i2++;
        while (usedNames.contains(testName)) {
            testName = String.valueOf(prefix) + i2++;
        }
        return testName;
    }

    public static List<XSDTypeDefinition> getAdvancedPrimitives() {
        advancedPrimitives = null;
        if (advancedPrimitives == null) {
            advancedPrimitives = new ArrayList<XSDTypeDefinition>();
            XSDSchema schemaForSchemas = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            for (String typeName : supportedPrimitives) {
                XSDSimpleTypeDefinition type = schemaForSchemas.resolveSimpleTypeDefinition(typeName);
                advancedPrimitives.add((XSDTypeDefinition)type);
            }
            Collections.sort(advancedPrimitives, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null || ((XSDTypeDefinition)o1).getName() == null) {
                        return 0;
                    }
                    return ((XSDTypeDefinition)o1).getName().compareToIgnoreCase(((XSDTypeDefinition)o2).getName());
                }
            });
        }
        return advancedPrimitives;
    }

    public static List<XSDTypeDefinition> getAllDataTypes(XSDSchema schema) {
        if (schema == null) {
            return Collections.emptyList();
        }
        ArrayList<XSDTypeDefinition> bos = new ArrayList<XSDTypeDefinition>();
        EList contents = schema.getContents();
        for (XSDSchemaContent item : contents) {
            if (!(item instanceof XSDTypeDefinition)) continue;
            bos.add((XSDTypeDefinition)item);
        }
        for (XSDSchemaContent item : contents) {
            XSDElementDeclaration element;
            if (!(item instanceof XSDElementDeclaration) || !((element = (XSDElementDeclaration)item).getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition)) continue;
            bos.add(element.getAnonymousTypeDefinition());
        }
        return bos;
    }

    public static List<XSDAttributeDeclaration> getChildAttributes(XSDComplexTypeDefinition bo) {
        EList attrContents = bo.getAttributeContents();
        ArrayList<XSDAttributeDeclaration> attrs = new ArrayList<XSDAttributeDeclaration>();
        int i = 0;
        while (i < attrContents.size()) {
            XSDAttributeGroupDefinition attrGroup;
            Object next = attrContents.get(i);
            if (next instanceof XSDAttributeUse) {
                attrs.add(((XSDAttributeUse)next).getContent().getResolvedAttributeDeclaration());
            } else if (next instanceof XSDAttributeGroupDefinition && (attrGroup = (XSDAttributeGroupDefinition)next).getResolvedAttributeGroupDefinition() != null) {
                attrContents.addAll((Collection)attrGroup.getResolvedAttributeGroupDefinition().getAttributeUses());
            }
            ++i;
        }
        return attrs;
    }

    public static List<XSDFeature> getChildElements(XSDComplexTypeDefinition bo) {
        return XSDUtils.getChildElements(XSDUtils.getModelGroup(bo));
    }

    public static List<XSDFeature> getChildElements(XSDFeature elem) {
        XSDComplexTypeDefinition cType = XSDUtils.getResolvedComplexType(elem);
        return cType != null ? XSDUtils.getChildElements(cType) : Collections.EMPTY_LIST;
    }

    public static List<XSDFeature> getChildElements(XSDModelGroup group) {
        if (group == null) {
            return new ArrayList<XSDFeature>();
        }
        ArrayList<XSDFeature> children = new ArrayList<XSDFeature>();
        for (XSDParticle next : group.getContents()) {
            if (next.getContent() instanceof XSDFeature) {
                children.add((XSDFeature)next.getContent());
                continue;
            }
            if (!(next.getTerm() instanceof XSDModelGroup)) continue;
            children.addAll(XSDUtils.getChildElements((XSDModelGroup)next.getTerm()));
        }
        return children;
    }

    public static String getDocumentation(XSDFeature element) {
        XSDAnnotation annotation = null;
        if (element instanceof XSDAttributeDeclaration) {
            annotation = ((XSDAttributeDeclaration)element).getAnnotation();
        } else if (element instanceof XSDElementDeclaration) {
            annotation = ((XSDElementDeclaration)element).getAnnotation();
        }
        if (annotation != null) {
            for (Element domElement : annotation.getUserInformation()) {
                if (!domElement.getTagName().endsWith("documentation") || !(domElement.getFirstChild() instanceof Text)) continue;
                return ((Text)domElement.getFirstChild()).getData();
            }
        }
        return null;
    }

    public static Map<String, String> getDocumentationAttributes(XSDTypeDefinition type) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (type.getAnnotation() != null) {
            XSDAnnotation annotation = type.getAnnotation();
            for (Element element : annotation.getUserInformation()) {
                if (!element.getTagName().endsWith("documentation")) continue;
                String source = element.getAttribute("source");
                String lang = element.getAttribute("xml:lang");
                if (lang == null || lang.length() < 1) {
                    lang = element.getAttribute("lang");
                }
                if (source != null && source.length() > 0) {
                    attributes.put("source", source);
                }
                if (lang != null && lang.length() > 0) {
                    attributes.put("xml:lang", lang);
                }
                return attributes;
            }
        }
        return null;
    }

    public static Map<String, String> getDocumentationAttributes(XSDFeature element) {
        XSDAnnotation annotation = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (element instanceof XSDAttributeDeclaration) {
            annotation = ((XSDAttributeDeclaration)element).getAnnotation();
        } else if (element instanceof XSDElementDeclaration) {
            annotation = ((XSDElementDeclaration)element).getAnnotation();
        }
        if (annotation != null) {
            for (Element domElement : annotation.getUserInformation()) {
                if (!domElement.getTagName().endsWith("documentation")) continue;
                String source = domElement.getAttribute("source");
                String lang = domElement.getAttribute("xml:lang");
                if (lang == null || lang.length() < 1) {
                    lang = domElement.getAttribute("lang");
                }
                if (source != null && source.length() > 0) {
                    attributes.put("source", source);
                }
                if (lang != null && lang.length() > 0) {
                    attributes.put("xml:lang", lang);
                }
                return attributes;
            }
        }
        return null;
    }

    public static String getDocumentation(XSDTypeDefinition type) {
        if (type.getAnnotation() != null) {
            XSDAnnotation annotation = type.getAnnotation();
            for (Element element : annotation.getUserInformation()) {
                if (!element.getTagName().endsWith("documentation") || !(element.getFirstChild() instanceof Text)) continue;
                return ((Text)element.getFirstChild()).getData();
            }
        }
        return null;
    }

    public static XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDComplexTypeContent content;
        XSDParticle particle = cType.getComplexType();
        if (particle == null || particle.eContainer() != cType) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        if ((group.getContents().isEmpty() || group.eResource() != cType.eResource()) && cType.getBaseType() != null && (content = cType.getContent()) instanceof XSDParticle) {
            particleContent = ((XSDParticle)content).getContent();
            if (particleContent instanceof XSDModelGroupDefinition) {
                group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
            } else if (particleContent instanceof XSDModelGroup) {
                group = (XSDModelGroup)particleContent;
            }
        }
        return group;
    }

    public static String getDisplayName(XSDNamedComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof XSDTypeDefinition) {
            return XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)component);
        }
        if (component instanceof XSDFeature) {
            XSDFeature feature = (XSDFeature)component;
            if (feature.getName() != null) {
                return feature.getName();
            }
            if (feature.getResolvedFeature() != null && feature.getResolvedFeature().getName() != null) {
                return feature.getResolvedFeature().getName();
            }
        }
        return component.getName();
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type) {
        return XSDUtils.getDisplayNameFromXSDType(type, true);
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type, boolean returnPrimitiveParents) {
        if (type == null) {
            return null;
        }
        if (type.getName() == null || type.getName().length() == 0) {
            if (returnPrimitiveParents && XSDUtils.isRestrictedPrimitiveType(type)) {
                return XSDUtils.getDisplayNameFromXSDType(type.getBaseType());
            }
            EObject container = type.eContainer();
            while (container != null) {
                if (container instanceof XSDNamedComponent && ((XSDNamedComponent)container).getName() != null) {
                    return ((XSDNamedComponent)container).getName();
                }
                container = container.eContainer();
            }
            return null;
        }
        return type.getName();
    }

    public static XSDSimpleTypeDefinition getPrimitive(String xsdName) {
        for (XSDSimpleTypeDefinition xSDSimpleTypeDefinition : XSDUtils.getAdvancedPrimitives()) {
            if (!xSDSimpleTypeDefinition.getName().equals(xsdName)) continue;
            return xSDSimpleTypeDefinition;
        }
        return null;
    }

    public static List<XSDSimpleTypeDefinition> getPrimitives() {
        if (primitives == null) {
            primitives = new ArrayList<XSDSimpleTypeDefinition>();
            XSDSchema schemaForSchemas = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            for (String typeName : xsdShortList) {
                XSDSimpleTypeDefinition type = schemaForSchemas.resolveSimpleTypeDefinition(typeName);
                primitives.add(type);
            }
            Collections.sort(primitives, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null || XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o1) == null) {
                        return 0;
                    }
                    return XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o1).compareTo(XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o2));
                }
            });
        }
        return primitives;
    }

    public static Collection<XSDComplexTypeDefinition> getReferencedTypes(XSDComplexTypeDefinition source) {
        if (source == null) {
            return Collections.emptySet();
        }
        ArrayList<XSDComplexTypeDefinition> results = new ArrayList<XSDComplexTypeDefinition>();
        for (XSDFeature element : XSDUtils.getChildElements(source)) {
            XSDComplexTypeDefinition elementType = XSDUtils.getResolvedComplexType(element);
            if (elementType == null || results.contains(elementType) || XSDConstants.isSchemaForSchemaNamespace((String)elementType.getTargetNamespace())) continue;
            results.add(elementType);
        }
        return results;
    }

    public static Collection<XSDTypeDefinition> getAllReferencedTypes(XSDComplexTypeDefinition source) {
        return XSDUtils.getAllReferencedTypes(source, false);
    }

    public static Collection<XSDTypeDefinition> getAllReferencedTypes(XSDComplexTypeDefinition source, boolean includeAnonymous) {
        if (source == null) {
            return Collections.emptySet();
        }
        ArrayList<XSDTypeDefinition> results = new ArrayList<XSDTypeDefinition>();
        XSDTypeDefinition elementType = null;
        for (XSDFeature next : XSDUtils.getChildElements(source)) {
            elementType = XSDUtils.getResolvedType(next);
            if (elementType == null || results.contains(elementType) || XSDConstants.isSchemaForSchemaNamespace((String)elementType.getTargetNamespace()) || !includeAnonymous && elementType.eContainer() == next) continue;
            results.add(elementType);
        }
        return results;
    }

    public static XSDComplexTypeDefinition getResolvedComplexType(XSDFeature feature) {
        XSDTypeDefinition resolvedType = XSDUtils.getResolvedType(feature);
        if (resolvedType instanceof XSDComplexTypeDefinition) {
            return (XSDComplexTypeDefinition)resolvedType;
        }
        return null;
    }

    public static XSDTypeDefinition getResolvedType(XSDFeature feature) {
        if (feature instanceof XSDElementDeclaration && ((XSDElementDeclaration)feature).getTypeDefinition() instanceof XSDComplexTypeDefinition) {
            EObject newType;
            XSDElementDeclaration element = (XSDElementDeclaration)feature;
            XSDComplexTypeDefinition oldType = (XSDComplexTypeDefinition)element.getTypeDefinition();
            if (oldType != (newType = EcoreUtil.resolve((EObject)element.getTypeDefinition(), (EObject)element))) {
                String oldName = oldType.getName();
                String newName = ((XSDTypeDefinition)newType).getName();
                String oldTNS = oldType.getTargetNamespace();
                String newTNS = ((XSDTypeDefinition)newType).getTargetNamespace();
                if ((oldName == newName || oldName != null && oldName.equals(newName)) && (oldTNS == newTNS || oldTNS != null && oldTNS.equals(newTNS))) {
                    element.setTypeDefinition((XSDTypeDefinition)newType);
                }
            }
            return element.getTypeDefinition();
        }
        if (feature.getType() != null) {
            return feature.getType();
        }
        if (feature.getResolvedFeature() != null && feature.getResolvedFeature().getType() != null) {
            return feature.getResolvedFeature().getType();
        }
        return null;
    }

    public static XSDTypeDefinition getRootType(XSDTypeDefinition type) {
        if (type == null) {
            return null;
        }
        XSDTypeDefinition baseType = type.getBaseType();
        while (baseType != null && !XSDConstants.isAnySimpleType((XSDTypeDefinition)baseType) && !XSDConstants.isAnyType((XSDTypeDefinition)baseType)) {
            type = baseType;
            baseType = type.getBaseType();
        }
        return type;
    }

    public static List<XSDSimpleTypeDefinition> getUserDefinedSimpleTypes(XSDSchema schema) {
        if (schema == null) {
            return Collections.emptyList();
        }
        ArrayList<XSDSimpleTypeDefinition> result = new ArrayList<XSDSimpleTypeDefinition>();
        for (XSDSchemaContent next : schema.getContents()) {
            if (!(next instanceof XSDSimpleTypeDefinition)) continue;
            result.add((XSDSimpleTypeDefinition)next);
        }
        return result;
    }

    public static String getXSDTypeFromDisplayName(String displayName) {
        return displayName;
    }

    public static boolean isRestrictedPrimitiveType(XSDTypeDefinition type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return false;
        }
        XSDTypeDefinition baseType = XSDUtils.getRootType(type);
        return XSDUtils.getAdvancedPrimitives().contains(baseType);
    }

    public static int getMinOccurs(XSDFeature xsdElem) {
        if (xsdElem.eContainer() instanceof XSDAttributeUse) {
            return ((XSDAttributeUse)xsdElem.eContainer()).getUse() == XSDAttributeUseCategory.REQUIRED_LITERAL ? 1 : 0;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        int min = 1;
        if (particle.isSetMinOccurs()) {
            min = particle.getMinOccurs();
        }
        return min;
    }

    public static int getMaxOccurs(XSDFeature xsdElem) {
        int max = 1;
        if (!(xsdElem.eContainer() instanceof XSDParticle)) {
            return max;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        if (particle.isSetMaxOccurs()) {
            max = particle.getMaxOccurs();
        }
        return max;
    }

    public static XSDTypeDefinition getDataType(XSDSchema schema, String typeName) {
        if (schema == null) {
            return null;
        }
        boolean pickFirstFound = typeName == null || typeName.length() < 1;
        EList contents = schema.getContents();
        for (Object item : contents) {
            if (!(item instanceof XSDTypeDefinition)) continue;
            if (pickFirstFound) {
                return (XSDTypeDefinition)item;
            }
            if (!typeName.equals(XSDUtils.getDisplayName((XSDNamedComponent)((XSDTypeDefinition)item)))) continue;
            return (XSDTypeDefinition)item;
        }
        for (Object item : contents) {
            XSDFeature element;
            XSDTypeDefinition resolvedType;
            if (!(item instanceof XSDFeature) || (resolvedType = XSDUtils.getResolvedType(element = (XSDFeature)item)) == null || resolvedType.getSchema() != schema) continue;
            if (pickFirstFound) {
                return resolvedType;
            }
            if (!typeName.equals(XSDUtils.getDisplayName((XSDNamedComponent)element))) continue;
            return resolvedType;
        }
        return null;
    }

    public static String getDefaultValue(XSDFeature xsdElem) {
        XSDConstraint constraint = null;
        if (xsdElem instanceof XSDAttributeDeclaration) {
            XSDAttributeUse use = (XSDAttributeUse)xsdElem.getContainer();
            if (use.isSetConstraint()) {
                constraint = use.getConstraint();
            }
            if (constraint != null && constraint.equals((Object)XSDConstraint.DEFAULT_LITERAL)) {
                if (use.getLexicalValue() != null) {
                    return use.getLexicalValue();
                }
                return "";
            }
        } else if (xsdElem instanceof XSDElementDeclaration) {
            if (xsdElem.isSetConstraint()) {
                constraint = xsdElem.getConstraint();
            }
            if (constraint != null && constraint.equals((Object)XSDConstraint.DEFAULT_LITERAL)) {
                if (xsdElem.getLexicalValue() != null) {
                    return xsdElem.getLexicalValue();
                }
                return "";
            }
        }
        return "";
    }

    public static XSDComplexTypeDefinition getEnclosingTypeDefinition(EObject component) {
        if (component == null) {
            return null;
        }
        if (component instanceof XSDComplexTypeDefinition) {
            return (XSDComplexTypeDefinition)component;
        }
        return XSDUtils.getEnclosingTypeDefinition(component.eContainer());
    }

    public static void removeImportsAndIncludes(XSDSchema schema, String oldTNS) {
        if (schema == null) {
            return;
        }
        String newTNS = schema.getTargetNamespace();
        if (newTNS == null && oldTNS == null) {
            return;
        }
        if (newTNS != null && newTNS.equals(oldTNS)) {
            return;
        }
        ArrayList schemaContents = new ArrayList(schema.getContents());
        for (Object next : schemaContents) {
            if (next instanceof XSDImport) {
                XSDImport nextImport = (XSDImport)next;
                if (nextImport.getNamespace() == null && newTNS == null) {
                    schema.getContents().remove((Object)nextImport);
                    continue;
                }
                if (nextImport.getNamespace() == null || !nextImport.getNamespace().equals(newTNS)) continue;
                schema.getContents().remove((Object)nextImport);
                continue;
            }
            if (!(next instanceof XSDSchemaCompositor)) continue;
            schema.getContents().remove(next);
        }
    }

    public static List<XSDFeature> getXSDElementsAndAttributes(XSDComplexTypeDefinition complexType) {
        List<XSDFeature> result = XSDUtils.getChildElements(complexType);
        result.addAll(XSDUtils.getChildAttributes(complexType));
        return result;
    }
}

