/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.JarEntryURIHelper;
import org.eclipse.xtext.ui.resource.Storage2UriMapperImpl;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Storage2UriMapperJavaImpl
extends Storage2UriMapperImpl
implements IElementChangedListener {
    private static final Logger log = Logger.getLogger(Storage2UriMapperJavaImpl.class);
    @Inject
    private JarEntryLocator locator;
    private SimpleCache<URI, Iterable<Pair<IStorage, IProject>>> cache = new SimpleCache((Function)new Function<URI, Iterable<Pair<IStorage, IProject>>>(){

        public Iterable<Pair<IStorage, IProject>> apply(URI from) {
            return Storage2UriMapperJavaImpl.this.findStoragesInJarsOrExternalClassFolders(from);
        }
    });

    public void setLocator(JarEntryLocator locator) {
        this.locator = locator;
    }

    public Storage2UriMapperJavaImpl() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1) {
            SimpleCache<URI, Iterable<Pair<IStorage, IProject>>> simpleCache = this.cache;
            synchronized (simpleCache) {
                this.cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        Iterable<Pair<IStorage, IProject>> storages = super.getStorages(uri);
        if (!storages.iterator().hasNext()) {
            SimpleCache<URI, Iterable<Pair<IStorage, IProject>>> simpleCache = this.cache;
            synchronized (simpleCache) {
                return (Iterable)this.cache.get((Object)uri);
            }
        }
        return storages;
    }

    @Override
    protected boolean isValidStorageFor(URI uri, IStorage storage) {
        IProject project;
        return !(storage instanceof IFile) || (project = ((IFile)storage).getProject()).isAccessible();
    }

    @Override
    protected URI internalGetUri(IStorage storage) {
        URI uri = super.internalGetUri(storage);
        if (uri != null) {
            return uri;
        }
        return this.computeUriForStorageInJarOrExternalClassFolder(storage);
    }

    protected Iterable<Pair<IStorage, IProject>> findStoragesInJarsOrExternalClassFolders(URI uri) {
        HashSet result = Sets.newHashSet();
        if (uri.isArchive()) {
            IProject[] projects;
            URI toArchive = this.getPathToArchive(uri);
            IProject[] iProjectArray = projects = this.getWorkspaceRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                if (iProject.isAccessible()) {
                    IJavaProject project = JavaCore.create((IProject)iProject);
                    this.findStoragesInJarsOfProject(toArchive, uri, project, result);
                }
                ++n2;
            }
        } else {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.getWorkspaceRoot().getProjects();
            int n = projects.length;
            int n3 = 0;
            while (n3 < n) {
                IProject project = iProjectArray[n3];
                if (project.isAccessible()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    this.findStoragesInExternalFoldersOfProject(uri, javaProject, result);
                }
                ++n3;
            }
        }
        return result;
    }

    protected void findStoragesInExternalFoldersOfProject(URI uri, IJavaProject project, Set<Pair<IStorage, IProject>> storages) {
        block5: {
            if (project.exists()) {
                try {
                    IPackageFragmentRoot[] fragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = project.getAllPackageFragmentRoots();
                    int n = fragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJarEntryResource storage;
                        IPackageFragmentRoot fragRoot = iPackageFragmentRootArray[n2];
                        if (fragRoot.isExternal() && !fragRoot.isArchive() && (storage = this.locator.getJarEntry(uri, fragRoot)) != null) {
                            storages.add((Pair<IStorage, IProject>)Tuples.create((Object)storage, (Object)project.getProject()));
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block5;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void findStoragesInJarsOfProject(URI toArchive, URI uri, IJavaProject project, Set<Pair<IStorage, IProject>> storages) {
        block5: {
            if (project.exists()) {
                try {
                    IPackageFragmentRoot[] fragmentRoots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = project.getAllPackageFragmentRoots();
                    int n = fragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJarEntryResource storage;
                        IPackageFragmentRoot fragRoot = iPackageFragmentRootArray[n2];
                        if (!"org.eclipse.jdt.launching.JRE_CONTAINER".equals(fragRoot.getRawClasspathEntry().getPath().toString()) && JarEntryURIHelper.getUriForPackageFragmentRoot(fragRoot).equals((Object)toArchive) && (storage = this.locator.getJarEntry(uri, fragRoot)) != null) {
                            storages.add((Pair<IStorage, IProject>)Tuples.create((Object)storage, (Object)project.getProject()));
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block5;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected URI computeUriForStorageInJarOrExternalClassFolder(IStorage storage) {
        URI uri;
        if (storage instanceof IJarEntryResource && this.isValidUri(uri = this.getUriForIJarEntryResource((IJarEntryResource)storage), storage)) {
            return uri;
        }
        return null;
    }

    protected URI getUriForIJarEntryResource(IJarEntryResource jarEntry) {
        return this.locator.getURI(jarEntry);
    }

    protected URI getPathToArchive(URI archiveURI) {
        if (!archiveURI.isArchive()) {
            throw new IllegalArgumentException("not an archive URI : " + archiveURI);
        }
        String string = archiveURI.toString();
        return URI.createURI((String)string.substring(archiveURI.scheme().length() + 1, string.indexOf(33)));
    }
}

