/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.quickfix.XtextResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationIssueProcessor
implements IValidationIssueProcessor,
IAnnotationModelListener {
    private static final Logger LOG = Logger.getLogger(AnnotationIssueProcessor.class);
    private final IAnnotationModel annotationModel;
    private AnnotationTypeLookup lookup = new AnnotationTypeLookup();
    private final IXtextDocument xtextDocument;
    private boolean updateMarkersOnModelChange;
    private final IssueResolutionProvider issueResolutionProvider;

    public AnnotationIssueProcessor(IXtextDocument xtextDocument, IAnnotationModel annotationModel, IssueResolutionProvider issueResolutionProvider) {
        this.annotationModel = annotationModel;
        if (annotationModel != null) {
            annotationModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
        this.xtextDocument = xtextDocument;
        this.issueResolutionProvider = issueResolutionProvider;
    }

    @Override
    public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
        this.updateMarkersOnModelChange = false;
        List<Annotation> toBeRemoved = this.getAnnotationsToRemove(monitor);
        ArrayListMultimap positionToAnnotations = ArrayListMultimap.create();
        Map<Annotation, Position> annotationToPosition = this.getAnnotationsToAdd((Multimap<Position, Annotation>)positionToAnnotations, issues, monitor);
        this.updateMarkerAnnotations(monitor);
        this.updateAnnotations(monitor, toBeRemoved, annotationToPosition);
        this.updateMarkersOnModelChange = true;
    }

    protected void updateAnnotations(IProgressMonitor monitor, List<Annotation> toBeRemoved, Map<Annotation, Position> annotationToPosition) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.annotationModel instanceof IAnnotationModelExtension) {
            Annotation[] annotationArray = toBeRemoved.toArray(new Annotation[toBeRemoved.size()]);
            ((IAnnotationModelExtension)this.annotationModel).replaceAnnotations(annotationArray, annotationToPosition);
        } else {
            for (Annotation annotation : toBeRemoved) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.annotationModel.removeAnnotation(annotation);
            }
            for (Map.Entry entry : annotationToPosition.entrySet()) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    protected List<Annotation> getAnnotationsToRemove(IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.annotationModel == null) {
            return Lists.newArrayList();
        }
        Iterator annotationIterator = this.annotationModel.getAnnotationIterator();
        ArrayList toBeRemoved = Lists.newArrayList();
        while (annotationIterator.hasNext()) {
            if (monitor.isCanceled()) {
                return toBeRemoved;
            }
            Annotation annotation = (Annotation)annotationIterator.next();
            String type = annotation.getType();
            if (!this.isRelevantAnnotationType(type) || annotation instanceof MarkerAnnotation) continue;
            toBeRemoved.add(annotation);
        }
        return toBeRemoved;
    }

    protected Map<Annotation, Position> getAnnotationsToAdd(Multimap<Position, Annotation> positionToAnnotations, List<Issue> issues, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return HashBiMap.create();
        }
        HashMap annotationToPosition = Maps.newHashMapWithExpectedSize((int)issues.size());
        for (Issue issue : issues) {
            if (monitor.isCanceled()) {
                return annotationToPosition;
            }
            if (!this.isSet(issue.getOffset()) || !this.isSet(issue.getLength()) || issue.getMessage() == null) continue;
            String type = this.lookup.getAnnotationType("org.eclipse.emf.ecore.diagnostic", this.getMarkerSeverity(issue.getSeverity()));
            boolean isQuickfixable = this.issueResolutionProvider.hasResolutionFor(issue.getCode());
            XtextAnnotation annotation = new XtextAnnotation(type, false, this.xtextDocument, issue, isQuickfixable);
            if (issue.getOffset() < 0 || issue.getLength() < 0) {
                LOG.error((Object)("Invalid annotation position offset=" + issue.getOffset() + " length = " + issue.getLength()));
            }
            Position position = new Position(Math.max(0, issue.getOffset()), Math.max(0, issue.getLength()));
            annotationToPosition.put(annotation, position);
            positionToAnnotations.put((Object)position, (Object)annotation);
        }
        return annotationToPosition;
    }

    protected boolean isSet(Integer length) {
        return length != null && length != -1;
    }

    protected int getMarkerSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    protected void updateMarkerAnnotations(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        UnmodifiableIterator annotationIterator = Iterators.filter((Iterator)this.annotationModel.getAnnotationIterator(), MarkerAnnotation.class);
        while (annotationIterator.hasNext() && !monitor.isCanceled()) {
            MarkerAnnotation annotation = (MarkerAnnotation)annotationIterator.next();
            if (annotation.isMarkedDeleted()) continue;
            try {
                boolean markAsDeleted;
                if (!this.isRelevantAnnotationType(annotation.getType()) || !(markAsDeleted = annotation.getMarker().isSubtypeOf("org.eclipse.xtext.ui.check.fast"))) continue;
                annotation.markDeleted(true);
                this.queueOrFireAnnotationChangedEvent(annotation);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.fireQueuedEvents();
    }

    protected void queueOrFireAnnotationChangedEvent(MarkerAnnotation annotation) {
        if (this.annotationModel instanceof XtextResourceMarkerAnnotationModel) {
            ((XtextResourceMarkerAnnotationModel)this.annotationModel).queueAnnotationChanged((Annotation)annotation);
        } else {
            this.announceAnnotationChanged((Annotation)annotation);
        }
    }

    protected void fireQueuedEvents() {
        if (this.annotationModel instanceof XtextResourceMarkerAnnotationModel) {
            ((XtextResourceMarkerAnnotationModel)this.annotationModel).fireQueuedEvents();
        }
    }

    protected void announceAnnotationChanged(Annotation annotation) {
        if (this.annotationModel instanceof XtextResourceMarkerAnnotationModel) {
            ((XtextResourceMarkerAnnotationModel)this.annotationModel).fireAnnotationChangedEvent(annotation);
        } else {
            Position position = this.annotationModel.getPosition(annotation);
            if (this.annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.annotationModel).modifyAnnotationPosition(annotation, position);
            } else {
                this.annotationModel.removeAnnotation(annotation);
                this.annotationModel.addAnnotation(annotation, position);
            }
        }
    }

    protected boolean isRelevantAnnotationType(String type) {
        return type.equals("org.eclipse.xtext.ui.editor.error") || type.equals("org.eclipse.xtext.ui.editor.warning");
    }

    public void modelChanged(IAnnotationModel model) {
        if (this.updateMarkersOnModelChange) {
            this.updateMarkerAnnotations((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

