/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TestConnectionDialog
extends StatusDialog
implements IShellProvider {
    private Label testConnectionLabel;
    private Label urlLabel;
    Point shellSize;
    Point shellLocation;
    private String infoCenterName = "";
    private String infoCenterHost = "";
    private String infoCenterPath = "";
    private String infoCenterPort = "";
    boolean successfullConnection = false;
    Color connectionColor;

    protected TestConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setSize(topComposite.computeSize(-1, -1));
        Composite topGroup = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        topGroup.setLayout((Layout)layout);
        topGroup.setLayoutData((Object)new GridData(768));
        this.createTestLabelSection(topGroup);
        this.createURLSection(topGroup);
        Dialog.applyDialogFont((Control)topGroup);
        return topGroup;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 150, this.shellSize.y);
        this.getShell().setText(Messages.TestConnectionDialog_4);
    }

    private void createTestLabelSection(Composite parent) {
        this.testConnectionLabel = new Label(parent, 512);
        this.testConnectionLabel.setText(NLS.bind((String)Messages.TestConnectionDialog_6, (Object)this.infoCenterName));
    }

    private void createURLSection(Composite parent) {
        this.urlLabel = new Label(parent, 512);
        String urlTemplate = Messages.TestConnectionDialog_URL_With_Param;
        String urlString = "http://" + this.infoCenterHost;
        urlString = this.infoCenterPort.equals("80") ? String.valueOf(urlString) + this.infoCenterPath : String.valueOf(urlString) + ":" + this.infoCenterPort + this.infoCenterPath;
        urlString = NLS.bind((String)urlTemplate, (Object)urlString);
        this.urlLabel.setText("\n" + urlString + '\n');
    }

    public void cancelPressed() {
        this.setReturnCode(0);
        if (this.connectionColor != null) {
            this.connectionColor.dispose();
        }
        this.close();
    }

    public void setValues(String icName, String icHost, String icPort, String icPath) {
        this.infoCenterName = icName;
        this.infoCenterHost = icHost;
        this.infoCenterPath = icPath;
        this.infoCenterPort = icPort;
    }

    public void create() {
        super.create();
        this.setConnectionStatus(this.successfullConnection);
    }

    public void setConnectionStatus(boolean testStatus) {
        this.successfullConnection = testStatus;
        StatusInfo status = new StatusInfo();
        if (this.successfullConnection) {
            status.setInfo(Messages.TestConnectionDialog_12);
        } else {
            status.setError(Messages.TestConnectionDialog_13);
        }
        this.updateStatus(status);
    }
}

