/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.parameters.scoping;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.amf.parameters.aPar.Import;
import org.eclipse.amp.amf.parameters.aPar.Model;
import org.eclipse.amp.amf.parameters.aPar.Parameter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAttribute;
import org.metaabm.SAttributed;
import org.metaabm.SContext;
import org.metaabm.SProjection;

@Singleton
public class AParScopeProvider
extends AbstractDeclarativeScopeProvider {
    List<IEObjectDescription> engineAttributes;
    ResourceSet resourceSet;
    SContext context;
    private List<IEObjectDescription> stringElems = new ArrayList<IEObjectDescription>();
    private List<IEObjectDescription> idElems = new ArrayList<IEObjectDescription>();

    public IScope getScope(EObject object, EReference reference) {
        if (object instanceof Import) {
            this.getAttributes((Import)object);
        } else if (object instanceof Parameter) {
            this.getAttributes(((Model)((Parameter)object).eContainer()).getModel());
        }
        if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAttribute()) {
            return new SimpleScope(this.idElems);
        }
        return super.getScope(object, reference);
    }

    protected void getAttributes(Import importModel) {
        String modelURIName = AParInterpreter.convertURI(importModel);
        URI modelURI = URI.createURI((String)modelURIName, (boolean)true);
        if (modelURI.isPlatform()) {
            SContext newContext;
            this.resourceSet = importModel.eContainer().eResource().getResourceSet();
            Resource resource = null;
            try {
                resource = this.resourceSet.getResource(modelURI, true);
            }
            catch (Exception e) {
                resource = this.resourceSet.getResource(modelURI, false);
            }
            if (resource != null && !resource.getContents().isEmpty() && (newContext = (SContext)resource.getContents().get(0)) != this.context) {
                this.idElems = new ArrayList<IEObjectDescription>();
                Resource engineResource = this.resourceSet.getResource(URI.createURI((String)"http://metaabm.org/Engine.metaabm"), true);
                SContext engine = (SContext)engineResource.getContents().get(0);
                this.findAttributes((SAttributed)engine);
                this.context = newContext;
                this.findAttributes((SAttributed)this.context);
            }
        }
    }

    protected void findAttributes(SAttributed attributed) {
        for (SAttribute attr : attributed.getAttributes()) {
            if (attr.isImmutable()) continue;
            this.addElem(attributed, attr);
        }
        if (attributed instanceof SContext) {
            for (SProjection proj : ((SContext)attributed).getProjections()) {
                this.findAttributes((SAttributed)proj);
            }
        }
    }

    private void addElem(SAttributed parent, SAttribute attr) {
        String id = StringUtils.capitalize((String)attr.getID());
        if (parent instanceof SProjection) {
            id = String.valueOf(StringUtils.capitalize((String)parent.getID())) + id;
        }
        this.idElems.add(EObjectDescription.create((String)id, (EObject)attr));
    }
}

