/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation.handlers;

import java.util.ResourceBundle;

public final class ConstraintHelper {
    private static final String FORDIAC_CONSTRAINT_PROPERTIES = "constraints";
    private static final ResourceBundle constraintProperties = ResourceBundle.getBundle("constraints");
    private final String message;
    private final int severity;

    public ConstraintHelper(String information) {
        String WARNING_PREFIX = "WARNING;";
        String INFO_PREFIX = "INFO;";
        String ERROR_PREFIX = "ERROR;";
        if (information.startsWith("WARNING;")) {
            this.severity = 1;
            this.message = ConstraintHelper.computeTranslatedMessage(information.substring("WARNING;".length()));
        } else if (information.startsWith("INFO;")) {
            this.severity = 0;
            this.message = ConstraintHelper.computeTranslatedMessage(information.substring("INFO;".length()));
        } else if (information.startsWith("ERROR;")) {
            this.severity = 2;
            this.message = ConstraintHelper.computeTranslatedMessage(information.substring("ERROR;".length()));
        } else {
            this.severity = 2;
            this.message = information;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    private static String computeTranslatedMessage(String message) {
        String key;
        if (message.startsWith("[") && message.endsWith("]") && constraintProperties.containsKey(key = message.substring(1, message.length() - 1))) {
            return constraintProperties.getString(key);
        }
        return message;
    }
}

