/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.InterfaceListImpl;
import org.eclipse.fordiac.ide.model.libraryElement.impl.OutMappedInOutVarAdapter;

class OutMappedInOutVarsEList
extends EObjectContainmentEList<VarDeclaration> {
    private static final long serialVersionUID = 1L;

    OutMappedInOutVarsEList(InterfaceListImpl owner, int featureID) {
        super(VarDeclaration.class, (InternalEObject)owner, featureID);
    }

    protected void didSet(int index, VarDeclaration newObject, VarDeclaration oldObject) {
        this.updateInOutVarReference(index, newObject);
    }

    protected void didAdd(int index, VarDeclaration newObject) {
        this.updateInOutVarReference(index, newObject);
    }

    protected void didRemove(int index, VarDeclaration oldObject) {
        this.removeInOutVarReference(index, oldObject);
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects != null) {
            int i = 0;
            while (i < size) {
                this.removeInOutVarReference(i, (VarDeclaration)oldObjects[i]);
                ++i;
            }
        }
    }

    protected void didMove(int index, VarDeclaration movedObject, int oldIndex) {
        this.updateInOutVarReference(index, movedObject);
    }

    protected void updateInOutVarReference(int index, VarDeclaration varDeclaration) {
        if (index >= this.getInterfaceList().getInOutVars().size()) {
            throw new IllegalStateException("No corresponding inOutVar found for outMappedInOutVar");
        }
        VarDeclaration inOutVar = (VarDeclaration)this.getInterfaceList().getInOutVars().get(index);
        OutMappedInOutVarAdapter adapter = OutMappedInOutVarAdapter.findAdapter(inOutVar);
        if (adapter == null) {
            throw new IllegalStateException("No OutMappedInOutVarAdapter found on corresponding inOutVar");
        }
        if (adapter.getOutMappedInOutVar() == null) {
            adapter.setOutMappedInOutVar(varDeclaration);
        } else if (adapter.getOutMappedInOutVar() != varDeclaration) {
            throw new IllegalStateException("Different outMappedInOutVar referenced in corresponding inOutVar");
        }
    }

    protected void removeInOutVarReference(int index, VarDeclaration varDeclaration) {
        if (index >= this.getInterfaceList().getInOutVars().size()) {
            return;
        }
        VarDeclaration inOutVar = (VarDeclaration)this.getInterfaceList().getInOutVars().get(index);
        OutMappedInOutVarAdapter adapter = OutMappedInOutVarAdapter.findAdapter(inOutVar);
        if (adapter == null) {
            throw new IllegalStateException("No OutMappedInOutVarAdapter found on corresponding inOutVar");
        }
        if (adapter.getOutMappedInOutVar() == varDeclaration) {
            adapter.setOutMappedInOutVar(null);
        }
    }

    InterfaceListImpl getInterfaceList() {
        return (InterfaceListImpl)this.getNotifier();
    }
}

