/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.LinkedHashSet;
import java.util.SequencedSet;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractVirtualWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IInterfaceElementWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;

public abstract class AbstractSubAppInterfaceWatch
extends AbstractVirtualWatch
implements IInterfaceElementWatch {
    private final boolean input;

    protected AbstractSubAppInterfaceWatch(Variable<?> variable, IInterfaceElement element, DeploymentDebugDevice debugTarget) {
        super(variable, (ITypedElement)element, AbstractSubAppInterfaceWatch.createWatches(element, debugTarget), debugTarget);
        this.input = element.isIsInput();
    }

    protected static SequencedSet<AbstractVirtualWatch.SubWatch> createWatches(IInterfaceElement element, DeploymentDebugDevice debugTarget) {
        return DeploymentDebugWatchUtils.resolveSubappInterfaceEndpoints(element).distinct().map(resolved -> AbstractSubAppInterfaceWatch.createSubWatch(resolved, debugTarget)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static AbstractVirtualWatch.SubWatch createSubWatch(DeploymentDebugWatchUtils.SubAppConnectionEndpoint<IInterfaceElement> endpoint, DeploymentDebugDevice debugTarget) throws EvaluatorException, UnsupportedOperationException {
        return new AbstractVirtualWatch.SubWatch((IVariableWatch)IWatch.watchFor(endpoint.element().getQualifiedName(), (INamedElement)endpoint.element(), debugTarget), endpoint.negate());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isInput() {
        return this.input;
    }

    @Override
    public IInterfaceElement getWatchedElement() {
        return (IInterfaceElement)super.getWatchedElement();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IInterfaceElement.class) {
            return adapter.cast(this.getWatchedElement());
        }
        return (T)super.getAdapter(adapter);
    }
}

