/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugStackFrame;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugValue;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class EvaluatorWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        if (context instanceof EvaluatorDebugStackFrame) {
            WatchExpressionResult watchResult;
            EvaluatorDebugStackFrame edsf = (EvaluatorDebugStackFrame)context;
            Evaluator evaluator = edsf.getEvaluator();
            Evaluator expressionEvaluator = EvaluatorFactory.createEvaluator((Object)expression, String.class, null, null, (Evaluator)evaluator);
            try {
                Value result = expressionEvaluator.evaluate();
                watchResult = new WatchExpressionResult(expression, EvaluatorDebugValue.forValue(result, expression, edsf.getDebugTarget()));
            }
            catch (EvaluatorException e) {
                watchResult = new WatchExpressionResult(expression, new DebugException(Status.error((String)e.getMessage(), (Throwable)e)));
            }
            catch (InterruptedException e) {
                watchResult = new WatchExpressionResult(expression, new DebugException(Status.error((String)e.getMessage(), (Throwable)e)));
                Thread.currentThread().interrupt();
            }
            try {
                listener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
            }
            catch (Exception e) {
                FordiacLogHelper.logWarning((String)("Exception in watch listener: " + e.getMessage()), (Exception)e);
            }
        }
    }

    public static class WatchExpressionResult
    implements IWatchExpressionResult {
        private final String expression;
        private final DebugException exception;
        private final IValue value;

        public WatchExpressionResult(String expression, IValue value) {
            this.expression = expression;
            this.exception = null;
            this.value = value;
        }

        public WatchExpressionResult(String expression, DebugException exception) {
            this.expression = expression;
            this.exception = exception;
            this.value = null;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.exception != null;
        }

        public String[] getErrorMessages() {
            if (this.hasErrors()) {
                return new String[]{this.exception.getMessage()};
            }
            return new String[0];
        }

        public String getExpressionText() {
            return this.expression;
        }

        public DebugException getException() {
            return this.exception;
        }
    }
}

