/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorExternalEventQueue;
import org.eclipse.fordiac.ide.model.libraryElement.Event;

public class FBLaunchEventQueue
implements FBEvaluatorCountingEventQueue,
FBEvaluatorExternalEventQueue {
    private final AtomicBoolean repeat;
    private final AtomicBoolean blocking;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final AtomicLong totalInputEventCount = new AtomicLong();
    private final ConcurrentMap<Event, AtomicInteger> eventCounts = new ConcurrentHashMap<Event, AtomicInteger>();

    public FBLaunchEventQueue(Event event, boolean repeat, boolean blocking) {
        this.repeat = new AtomicBoolean(repeat);
        this.blocking = new AtomicBoolean(blocking);
        if (event != null) {
            this.queue.add(event);
        }
    }

    public Event receiveInputEvent() throws InterruptedException {
        Event result;
        Event event = result = this.blocking.get() ? this.queue.take() : (Event)this.queue.poll();
        if (result != null) {
            this.incrementEventCount(result);
            if (this.repeat.get()) {
                this.queue.add(result);
            }
        }
        return result;
    }

    public boolean sendOutputEvent(Event event) {
        this.incrementEventCount(event);
        return true;
    }

    public boolean triggerInputEvent(Event event) {
        return this.queue.offer(event);
    }

    protected void incrementEventCount(Event ev) {
        AtomicInteger count = this.getCount(ev);
        count.incrementAndGet();
        if (ev.isIsInput()) {
            this.totalInputEventCount.incrementAndGet();
        }
    }

    public AtomicInteger getCount(Event ev) {
        return this.eventCounts.computeIfAbsent(ev, e -> new AtomicInteger());
    }

    public AtomicLong getTotalInputCount() {
        return this.totalInputEventCount;
    }

    public boolean isRepeat() {
        return this.repeat.get();
    }

    public void setRepeat(boolean repeat) {
        this.repeat.set(repeat);
    }

    public boolean isBlocking() {
        return this.blocking.get();
    }

    public void setBlocking(boolean blocking) {
        this.blocking.set(blocking);
    }
}

