/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate;

import org.eclipse.elk.alg.radial.intermediate.CalculateGraphSize;
import org.eclipse.elk.alg.radial.intermediate.EdgeAngleCalculator;
import org.eclipse.elk.alg.radial.intermediate.compaction.GeneralCompactor;
import org.eclipse.elk.alg.radial.intermediate.overlaps.RadiusExtensionOverlapRemoval;
import org.eclipse.elk.alg.radial.intermediate.rotation.GeneralRotator;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.graph.ElkNode;

public enum IntermediateProcessorStrategy implements ILayoutProcessorFactory<ElkNode>
{
    OVERLAP_REMOVAL,
    COMPACTION,
    ROTATION,
    GRAPH_SIZE_CALCULATION,
    OUTGOING_EDGE_ANGLES;


    public ILayoutProcessor<ElkNode> create() {
        switch (this) {
            case OVERLAP_REMOVAL: {
                return new RadiusExtensionOverlapRemoval();
            }
            case COMPACTION: {
                return new GeneralCompactor();
            }
            case ROTATION: {
                return new GeneralRotator();
            }
            case GRAPH_SIZE_CALCULATION: {
                return new CalculateGraphSize();
            }
            case OUTGOING_EDGE_ANGLES: {
                return new EdgeAngleCalculator();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layout processor " + this.toString());
    }
}

