/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.bulkeditor.Messages;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorSettings;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class FilterComposite
extends Composite {
    private final List<Filter> filterList = new ArrayList<Filter>();
    private final List<String> filterNames;
    private final int firstItemWidth;
    private final List<Consumer<String>> textChangedListeners = new ArrayList<Consumer<String>>();
    private final List<Runnable> filterChangedListeners = new ArrayList<Runnable>();

    public FilterComposite(Composite parent, int style, List<String> filterNames, BulkEditorSettings settings, List<String> subSettingsReferencesNames) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, false));
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        this.firstItemWidth = FilterComposite.calculateMaxCheckboxWidth(parent, filterNames);
        this.filterNames = filterNames;
        int i = 0;
        while (i < filterNames.size()) {
            Filter filter = new Filter(this, style, filterNames.get(i));
            this.filterList.add(filter);
            if (i < subSettingsReferencesNames.size()) {
                filter.addListenerSubSetting(settings.getSubSettings(subSettingsReferencesNames.get(i)));
            }
            ++i;
        }
    }

    public void clear() {
        this.filterList.forEach(Filter::access$0);
    }

    private static int calculateMaxCheckboxWidth(Composite parent, List<String> names) {
        int maxWidth = 0;
        GC gc = new GC((Drawable)parent);
        for (String name : names) {
            int textWidth = gc.textExtent((String)name).x + 20;
            if (textWidth <= maxWidth) continue;
            maxWidth = textWidth;
        }
        gc.dispose();
        return maxWidth;
    }

    public void addTextChangedListener(Consumer<String> listener) {
        this.textChangedListeners.add(listener);
        listener.accept(this.createFiltersText());
    }

    public void addFilterChangedListener(Runnable listener) {
        this.filterChangedListeners.add(listener);
    }

    private String createFiltersText() {
        StringBuilder sb = new StringBuilder();
        String text = this.filterList.stream().filter(filter -> filter.selected.getSelection()).map(filter -> filter.name + ": " + filter.textField.getText()).collect(Collectors.joining(", "));
        if (!text.isEmpty()) {
            sb.append('(');
            sb.append(text);
            sb.append(')');
        }
        return sb.toString();
    }

    public Filter getFilter(String filterName) {
        int index = this.filterNames.indexOf(filterName);
        if (index >= 0 && index < this.filterList.size()) {
            return this.filterList.get(index);
        }
        return null;
    }

    public class Filter
    extends Composite {
        private static final String IMAGE_BUNDLE = "org.eclipse.ui.workbench.texteditor";
        private static final String CASE_SENSITVE_IMAGE = "icons/full/elcl16/case_sensitive.png";
        private static final String EXACT_MATCH_IMAGE = "icons/full/elcl16/whole_word.png";
        private static final String REGULAR_EXPRESSION_IMAGE = "icons/full/elcl16/regex.png";
        public final String name;
        private BulkEditorSettings.BulkEditorSubSettings subSetting;
        public final Button selected;
        public final Text textField;
        public final Button caseSensitive;
        public final Button wholeWord;
        public final Button exactMatch;
        public final Button regularExpression;

        public Filter(Composite parent, int style, String name) {
            super(parent, style);
            this.name = name;
            this.setLayoutData(new GridData(4, 4, true, false));
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(6).create());
            this.selected = (Button)WidgetFactory.button((int)32).text(name).create((Widget)this);
            this.selected.setLayoutData((Object)GridDataFactory.swtDefaults().hint(FilterComposite.this.firstItemWidth, -1).create());
            this.textField = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 4, true, false))).create((Widget)this);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(CASE_SENSITVE_IMAGE)));
            this.caseSensitive = this.createImageButton(descriptor, Messages.CaseSensitve);
            descriptor = FordiacImage.ICON_WHOLE_WORD.getImageDescriptor();
            this.wholeWord = this.createImageButton(descriptor, Messages.WholeWord);
            descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(EXACT_MATCH_IMAGE)));
            this.exactMatch = this.createImageButton(descriptor, Messages.ExactMatch);
            descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(REGULAR_EXPRESSION_IMAGE)));
            this.regularExpression = this.createImageButton(descriptor, Messages.RegularExpression);
            this.selected.addListener(13, event -> {
                this.textField.setEnabled(this.selected.getSelection());
                this.caseSensitive.setEnabled(this.selected.getSelection());
                this.wholeWord.setEnabled(this.selected.getSelection() && !this.exactMatch.getSelection() && !this.regularExpression.getSelection());
                this.exactMatch.setEnabled(this.selected.getSelection() && !this.wholeWord.getSelection());
                this.regularExpression.setEnabled(this.selected.getSelection() && !this.wholeWord.getSelection());
            });
        }

        private Button createImageButton(ImageDescriptor descriptor, String tooltip) {
            Image image = descriptor.createImage();
            Button button = (Button)((ButtonFactory)WidgetFactory.button((int)2).image(image).tooltip(tooltip)).create((Widget)this);
            button.addDisposeListener(e -> image.dispose());
            return button;
        }

        private void addListenerSubSetting(BulkEditorSettings.BulkEditorSubSettings subSetting) {
            this.subSetting = subSetting;
            boolean isSelected = subSetting.selected;
            this.selected.setSelection(isSelected);
            this.selected.addListener(13, event -> {
                this.subSetting.selected = this.selected.getSelection();
                this.fireTextChanged();
                this.fireFilterChanged();
            });
            this.textField.setText(subSetting.textField);
            this.textField.addModifyListener(event -> {
                this.subSetting.textField = this.textField.getText();
                this.fireTextChanged();
                this.fireFilterChanged();
            });
            this.caseSensitive.setSelection(subSetting.caseSensitive);
            this.caseSensitive.addListener(13, event -> {
                bulkEditorSubSettings.caseSensitive = this.caseSensitive.getSelection();
                this.fireFilterChanged();
            });
            this.wholeWord.setSelection(subSetting.wholeWord);
            this.wholeWord.addListener(13, event -> {
                this.subSetting.wholeWord = this.wholeWord.getSelection();
                this.exactMatch.setEnabled(!this.wholeWord.getSelection());
                this.regularExpression.setEnabled(!this.wholeWord.getSelection());
                this.fireFilterChanged();
            });
            this.exactMatch.setSelection(subSetting.exactMatch);
            this.exactMatch.addListener(13, event -> {
                this.subSetting.exactMatch = this.exactMatch.getSelection();
                this.wholeWord.setEnabled(!this.exactMatch.getSelection() && !this.regularExpression.getSelection());
                this.fireFilterChanged();
            });
            this.regularExpression.setSelection(subSetting.regularExpression);
            this.regularExpression.addListener(13, event -> {
                this.subSetting.regularExpression = this.regularExpression.getSelection();
                this.wholeWord.setEnabled(!this.exactMatch.getSelection() && !this.regularExpression.getSelection());
                this.fireFilterChanged();
            });
            this.selected.notifyListeners(13, null);
        }

        private void clear() {
            this.selected.setSelection(false);
            this.textField.setText("");
            this.caseSensitive.setSelection(false);
            this.wholeWord.setSelection(false);
            this.exactMatch.setSelection(false);
            this.regularExpression.setSelection(false);
            this.subSetting.selected = false;
            this.subSetting.textField = "";
            this.subSetting.caseSensitive = false;
            this.subSetting.wholeWord = false;
            this.subSetting.exactMatch = false;
            this.subSetting.regularExpression = false;
            this.selected.notifyListeners(13, null);
        }

        private void fireFilterChanged() {
            FilterComposite.this.filterChangedListeners.forEach(Runnable::run);
        }

        private void fireTextChanged() {
            String newText = FilterComposite.this.createFiltersText();
            FilterComposite.this.textChangedListeners.forEach(listener -> listener.accept(newText));
        }

        static /* synthetic */ void access$0(Filter filter) {
            filter.clear();
        }
    }
}

