/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class FastInverseCrossReferencesList
extends BasicEList<EStructuralFeature.Setting> {
    private static final long serialVersionUID = 1L;
    private static final int THRESHOLD = 100;
    private Map<EObject, Object> map;
    private BooleanSupplier checkUnique;

    public FastInverseCrossReferencesList(BooleanSupplier checkUnique) {
        this.checkUnique = checkUnique;
    }

    protected Object[] newData(int capacity) {
        return new EStructuralFeature.Setting[capacity];
    }

    protected void didAdd(int index, EStructuralFeature.Setting setting) {
        if (this.map != null) {
            EObject eObject = setting.getEObject();
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            Object object = this.map.get(eObject);
            if (object == null) {
                this.map.put(eObject, eStructuralFeature);
            } else if (object instanceof Object[]) {
                Object[] oldFeatures = (Object[])object;
                Object[] newFeatures = new Object[oldFeatures.length + 1];
                System.arraycopy(oldFeatures, 0, newFeatures, 0, oldFeatures.length);
                newFeatures[oldFeatures.length] = eStructuralFeature;
                this.map.put(eObject, newFeatures);
            } else {
                Object[] newFeatures = new Object[]{object, eStructuralFeature};
                this.map.put(eObject, newFeatures);
            }
        }
    }

    protected void didRemove(int index, EStructuralFeature.Setting setting) {
        if (this.map != null) {
            if (this.size < 50) {
                this.map = null;
            } else {
                EObject eObject = setting.getEObject();
                Object object = this.map.get(eObject);
                if (object instanceof Object[]) {
                    Object[] oldFeatures = (Object[])object;
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (oldFeatures.length == 2) {
                        this.map.put(eObject, oldFeatures[0] == eStructuralFeature ? oldFeatures[1] : oldFeatures[0]);
                    } else {
                        Object[] newFeatures = new Object[oldFeatures.length - 1];
                        int i = 0;
                        while (i < oldFeatures.length) {
                            Object oldFeature = oldFeatures[i];
                            if (oldFeature == eStructuralFeature) {
                                System.arraycopy(oldFeatures, i + 1, newFeatures, i, oldFeatures.length - i - 1);
                                break;
                            }
                            newFeatures[i] = oldFeatures[i];
                            ++i;
                        }
                        this.map.put(eObject, newFeatures);
                    }
                } else {
                    this.map.remove(eObject);
                }
            }
        }
    }

    public boolean add(EStructuralFeature.Setting setting) {
        if (this.size > 0 && this.checkUnique.getAsBoolean()) {
            EObject eObject = setting.getEObject();
            if (this.size > 100) {
                Object object;
                if (this.map == null) {
                    this.map = new HashMap<EObject, Object>();
                    EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])this.data;
                    int i = 0;
                    while (i < this.size) {
                        this.didAdd(i, settingData[i]);
                        ++i;
                    }
                }
                if ((object = this.map.get(eObject)) != null) {
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (object == eStructuralFeature) {
                        return false;
                    }
                    if (object instanceof Object[]) {
                        Object[] features = (Object[])object;
                        int i = 0;
                        while (i < features.length) {
                            if (features[i] == eStructuralFeature) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
            } else {
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])this.data;
                int i = 0;
                while (i < this.size) {
                    EStructuralFeature.Setting containedSetting = settingData[i];
                    if (containedSetting.getEObject() == eObject && containedSetting.getEStructuralFeature() == eStructuralFeature) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        this.addUnique(setting);
        return true;
    }
}

