/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.breakpoint;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.debug.breakpoint.EvaluatorLineBreakpoint;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

public abstract class CommonToggleBreakpointsTargetExtension
implements IAdapterFactory,
IToggleBreakpointsTargetExtension {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        XtextEditor editor;
        IEditorInput editorInput;
        if (part instanceof XtextEditor && (editorInput = (editor = (XtextEditor)part).getEditorInput()) instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)editorInput).getFile();
            if (selection instanceof ITextSelection) {
                int line = ((ITextSelection)selection).getStartLine() + 1;
                EvaluatorLineBreakpoint existingBreakpoint = this.findExistingBreakpoint((IResource)resource, line);
                if (existingBreakpoint != null) {
                    existingBreakpoint.delete();
                    return;
                }
                if (!((Boolean)editor.getDocument().tryReadOnly(state -> this.isValidLineForBreakPoint((XtextResource)state, line))).booleanValue()) {
                    return;
                }
                EvaluatorLineBreakpoint breakpoint = this.createBreakpoint((IResource)resource, line);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
            }
        }
    }

    protected EvaluatorLineBreakpoint findExistingBreakpoint(IResource res, int line) throws CoreException {
        IBreakpoint[] breakpoints;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpoints = manager.getBreakpoints("org.eclipse.fordiac.ide.debug.model");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            EvaluatorLineBreakpoint testBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            IMarker marker = breakpoint.getMarker();
            if (this.isValidBreakpointType(breakpoint) && marker.getResource().equals((Object)res) && (testBreakpoint = (EvaluatorLineBreakpoint)breakpoint).getLineNumber() == line) {
                return testBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    protected boolean isValidLineForBreakPoint(XtextResource resource, int line) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return false;
        }
        ICompositeNode node = parseResult.getRootNode();
        return this.isValidLineForBreakPoint(node, line);
    }

    protected boolean isValidLineForBreakPoint(ICompositeNode node, int line) {
        for (INode n : node.getChildren()) {
            ITextRegionWithLineInformation textRegion = n.getTextRegionWithLineInformation();
            if (textRegion.getLineNumber() <= line && textRegion.getEndLineNumber() >= line) {
                EObject eObject;
                if (n.hasDirectSemanticElement() && textRegion.getLineNumber() == line && this.isValidSematicElementForBreakpoint(eObject = n.getSemanticElement())) {
                    return true;
                }
                if (n instanceof ICompositeNode && this.isValidLineForBreakPoint((ICompositeNode)n, line)) {
                    return true;
                }
            }
            if (textRegion.getLineNumber() <= line) continue;
            return false;
        }
        return false;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof XtextEditor && this.isApplicable((XtextEditor)adaptableObject) && adapterType == IToggleBreakpointsTarget.class) {
            return (T)this;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IToggleBreakpointsTarget.class};
    }

    protected abstract boolean isApplicable(XtextEditor var1);

    protected abstract boolean isValidSematicElementForBreakpoint(EObject var1);

    protected abstract boolean isValidBreakpointType(IBreakpoint var1);

    protected abstract EvaluatorLineBreakpoint createBreakpoint(IResource var1, int var2) throws CoreException;
}

