/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ViewNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaViewNode
extends UaNode
implements ViewNode {
    private Boolean containsNoLoops;
    private UByte eventNotifier;

    public UaViewNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean containsNoLoops, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    public synchronized Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public synchronized UByte getEventNotifier() {
        return this.eventNotifier;
    }

    public synchronized void setContainsNoLoops(Boolean containsNoLoops) {
        this.containsNoLoops = containsNoLoops;
    }

    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
    }

    public Boolean readContainsNoLoops() throws UaException {
        DataValue value = this.readAttribute(AttributeId.ContainsNoLoops);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read ContainsNoLoops failed");
        }
        Boolean containsNoLoops = (Boolean)value.getValue().getValue();
        this.setContainsNoLoops(containsNoLoops);
        return containsNoLoops;
    }

    public UByte readEventNotifier() throws UaException {
        DataValue value = this.readAttribute(AttributeId.EventNotifier);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read EventNotifier failed");
        }
        UByte eventNotifier = (UByte)value.getValue().getValue();
        this.setEventNotifier(eventNotifier);
        return eventNotifier;
    }

    public void writeContainsNoLoops(Boolean containsNoLoops) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)containsNoLoops));
        StatusCode statusCode = this.writeAttribute(AttributeId.ContainsNoLoops, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write ContainsNoLoops failed");
        }
        this.setContainsNoLoops(containsNoLoops);
    }

    public void writeEventNotifier(UByte eventNotifier) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventNotifier));
        StatusCode statusCode = this.writeAttribute(AttributeId.EventNotifier, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write EventNotifier failed");
        }
        this.setEventNotifier(eventNotifier);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(ViewNodeProperties.NodeVersion);
    }

    public CompletableFuture<? extends UInteger> readViewVersionAsync() {
        return this.getProperty(ViewNodeProperties.ViewVersion);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(ViewNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> writeViewVersionAsync(UInteger viewVersion) {
        return this.setProperty(ViewNodeProperties.ViewVersion, viewVersion);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case ContainsNoLoops: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getContainsNoLoops()));
            }
            case EventNotifier: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getEventNotifier()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case ContainsNoLoops: {
                this.setContainsNoLoops((Boolean)value.getValue().getValue());
                break;
            }
            case EventNotifier: {
                this.setEventNotifier((UByte)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

