/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.options.StressOptions;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class StressMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean FIXED_DEFAULT = false;
    public static final IProperty<Boolean> FIXED = new Property("org.eclipse.elk.stress.fixed", (Object)false, null, null);
    private static final double DESIRED_EDGE_LENGTH_DEFAULT = 100.0;
    public static final IProperty<Double> DESIRED_EDGE_LENGTH = new Property("org.eclipse.elk.stress.desiredEdgeLength", (Object)100.0, null, null);
    private static final StressMajorization.Dimension DIMENSION_DEFAULT = StressMajorization.Dimension.XY;
    public static final IProperty<StressMajorization.Dimension> DIMENSION = new Property("org.eclipse.elk.stress.dimension", (Object)DIMENSION_DEFAULT, null, null);
    private static final double EPSILON_DEFAULT = 0.001;
    public static final IProperty<Double> EPSILON = new Property("org.eclipse.elk.stress.epsilon", (Object)0.001, null, null);
    private static final int ITERATION_LIMIT_DEFAULT = Integer.MAX_VALUE;
    public static final IProperty<Integer> ITERATION_LIMIT = new Property("org.eclipse.elk.stress.iterationLimit", (Object)Integer.MAX_VALUE, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.stress.fixed").group("").name("Fixed Position").description("Prevent that the node is moved by the layout algorithm.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.stress.desiredEdgeLength").group("").name("Desired Edge Length").description("Either specified for parent nodes or for individual edges, where the latter takes higher precedence.").defaultValue((Object)100.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS, LayoutOptionData.Target.EDGES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.stress.dimension").group("").name("Layout Dimension").description("Dimensions that are permitted to be altered during layout.").defaultValue((Object)DIMENSION_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(StressMajorization.Dimension.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.stress.epsilon").group("").name("Stress Epsilon").description("Termination criterion for the iterative process.").defaultValue((Object)0.001).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.stress.iterationLimit").group("").name("Iteration Limit").description("Maximum number of performed iterations. Takes higher precedence than 'epsilon'.").defaultValue((Object)Integer.MAX_VALUE).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        new StressOptions().apply(registry);
    }
}

