/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.gef.provider.VersionContentProvider;
import org.eclipse.fordiac.ide.gef.provider.VersionLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeApplicationDomainCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAuthorCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeClassificationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDateCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDescriptionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFunctionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeIdentifcationTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOrganizationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeRemarksCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStandardCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVersionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewVersionInfoCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteVersionInfoCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TypeInfoWidget
implements CommandExecutor {
    private static final int MAX_MINUS_T_MIN = 70;
    private static final int MAX_MINUS_MIN = 90;
    private static final int T_MIN = 30;
    private static final int D_MIN = 20;
    private static final int MAX = 100;
    private static final int MIN = 10;
    private final FormToolkit widgetFactory;
    private Consumer<Command> commandExecutor;
    private LibraryElement type;
    private Text standardText;
    private Text classificationText;
    private Text domainText;
    private Text functionText;
    private Text typeText;
    private Text descriptionText;
    protected boolean blockListeners;
    private TableViewer versionViewer;
    private AddDeleteWidget addDeleteVersionInfoButtons;
    private static final String VERSION_PROPERTY = "version";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String DATE_PROPERTY = "date";
    private static final String REMARKS_PROPERTY = "remarks";

    public TypeInfoWidget(FormToolkit widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    protected FormToolkit getWidgetFactory() {
        return this.widgetFactory;
    }

    public Composite createControls(Composite parent) {
        this.createControls(this.createComposite(parent), this.createComposite(parent));
        return parent;
    }

    public void createControls(Composite leftComposite, Composite rightComposite) {
        this.createIdentificationGroup(leftComposite);
        this.createVersionInfoGroup(rightComposite);
    }

    private void createIdentificationGroup(Composite parent) {
        Group identificationGroup = this.createGroup(parent, FordiacMessages.Identification);
        identificationGroup.setLayout((Layout)new GridLayout(2, false));
        identificationGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.Standard + ":");
        this.standardText = this.createGroupText((Composite)identificationGroup, true);
        this.standardText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeStandardCommand(this.type, this.standardText.getText()));
            }
        });
        this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.Classification + ":");
        this.classificationText = this.createGroupText((Composite)identificationGroup, true);
        this.classificationText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeClassificationCommand(this.type, this.classificationText.getText()));
            }
        });
        this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.ApplicationDomain + ":");
        this.domainText = this.createGroupText((Composite)identificationGroup, true);
        this.domainText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeApplicationDomainCommand(this.type, this.domainText.getText()));
            }
        });
        this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.Function + ":");
        this.functionText = this.createGroupText((Composite)identificationGroup, true);
        this.functionText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeFunctionCommand(this.type, this.functionText.getText()));
            }
        });
        this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.Type + ":");
        this.typeText = this.createGroupText((Composite)identificationGroup, true);
        this.typeText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeIdentifcationTypeCommand(this.type, this.typeText.getText()));
            }
        });
        Label label = this.getWidgetFactory().createLabel((Composite)identificationGroup, FordiacMessages.Description + ":");
        label.setLayoutData((Object)new GridData(0, 128, false, false));
        this.descriptionText = this.getWidgetFactory().createText((Composite)identificationGroup, "", 2882);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangeDescriptionCommand(this.type, this.descriptionText.getText()));
            }
        });
    }

    private void createVersionInfoGroup(Composite parent) {
        Group versionInfoGroup = this.createGroup(parent, FordiacMessages.VersionInfo);
        versionInfoGroup.setLayout((Layout)new GridLayout(2, false));
        versionInfoGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addDeleteVersionInfoButtons = new AddDeleteWidget();
        this.addDeleteVersionInfoButtons.createControls((Composite)versionInfoGroup, this.getWidgetFactory());
        this.versionViewer = TableWidgetFactory.createPropertyTableViewer((Composite)versionInfoGroup);
        TypeInfoWidget.configureTableLayout(this.versionViewer.getTable());
        Table table = this.versionViewer.getTable();
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.versionViewer.setColumnProperties(new String[]{VERSION_PROPERTY, ORGANIZATION_PROPERTY, AUTHOR_PROPERTY, DATE_PROPERTY, REMARKS_PROPERTY});
        this.addDeleteVersionInfoButtons.bindToTableViewer(this.versionViewer, (CommandExecutor)this, ref -> new AddNewVersionInfoCommand(this.type), ref -> new DeleteVersionInfoCommand(this.type, (VersionInfo)ref));
        this.versionViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return switch (property) {
                    case TypeInfoWidget.VERSION_PROPERTY -> ((VersionInfo)element).getVersion();
                    case TypeInfoWidget.ORGANIZATION_PROPERTY -> ((VersionInfo)element).getOrganization();
                    case TypeInfoWidget.AUTHOR_PROPERTY -> ((VersionInfo)element).getAuthor();
                    case TypeInfoWidget.DATE_PROPERTY -> ((VersionInfo)element).getDate();
                    default -> ((VersionInfo)element).getRemarks();
                };
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                VersionInfo data = (VersionInfo)tableItem.getData();
                ChangeRemarksCommand cmd = null;
                cmd = switch (property) {
                    case TypeInfoWidget.VERSION_PROPERTY -> new ChangeVersionCommand(data, value.toString());
                    case TypeInfoWidget.ORGANIZATION_PROPERTY -> new ChangeOrganizationCommand(data, value.toString());
                    case TypeInfoWidget.AUTHOR_PROPERTY -> new ChangeAuthorCommand(data, value.toString());
                    case TypeInfoWidget.DATE_PROPERTY -> new ChangeDateCommand(data, value.toString());
                    default -> new ChangeRemarksCommand(data, value.toString());
                };
                TypeInfoWidget.this.executeCommand((Command)cmd);
                TypeInfoWidget.this.versionViewer.refresh((Object)data);
            }
        });
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Version);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Organization);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Author);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.Date);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.Remarks);
        TableLayout layout = new TableLayout(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 100));
        table.setLayout((Layout)layout);
    }

    private Composite createComposite(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    protected Text createGroupText(Composite group, boolean editable) {
        Text text = this.getWidgetFactory().createText(group, "", 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    public void initialize(LibraryElement type, Consumer<Command> commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.type = type;
    }

    public void refresh() {
        if (this.type != null && this.versionViewer != null && !this.versionViewer.getControl().isDisposed()) {
            Consumer<Command> commandExecutorBuffer = this.commandExecutor;
            this.commandExecutor = null;
            if (this.type.getIdentification() != null) {
                this.setIdentTextAll();
            }
            if (this.type.getVersionInfo() != null) {
                this.versionViewer.setInput((Object)this.type);
            }
            this.commandExecutor = commandExecutorBuffer;
        }
    }

    private void setIdentTextAll() {
        Identification id = this.type.getIdentification();
        this.standardText.setText(id.getStandard() != null ? id.getStandard() : "");
        this.classificationText.setText(id.getClassification() != null ? id.getClassification() : "");
        this.domainText.setText(id.getApplicationDomain() != null ? id.getApplicationDomain() : "");
        this.functionText.setText(id.getFunction() != null ? id.getFunction() : "");
        this.typeText.setText(id.getType() != null ? id.getType() : "");
        this.descriptionText.setText(id.getDescription() != null ? id.getDescription() : "");
    }

    public void executeCommand(Command cmd) {
        if (this.commandExecutor != null) {
            this.blockListeners = true;
            this.commandExecutor.accept(cmd);
            this.blockListeners = false;
        }
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 32);
        group.setText(text);
        this.getWidgetFactory().adapt((Composite)group);
        return group;
    }

    public void setEnabled(boolean enablement) {
        this.standardText.setEnabled(enablement);
        this.classificationText.setEnabled(enablement);
        this.domainText.setEnabled(enablement);
        this.functionText.setEnabled(enablement);
        this.typeText.setEnabled(enablement);
        this.descriptionText.setEnabled(enablement);
        this.addDeleteVersionInfoButtons.setEnabled(enablement);
        this.versionViewer.setCellModifier(null);
    }

    protected LibraryElement getType() {
        return this.type;
    }

    protected Consumer<Command> getCommandExecutor() {
        return this.commandExecutor;
    }

    protected void setCommandExecutor(Consumer<Command> commandExecutor) {
        this.commandExecutor = commandExecutor;
    }
}

