/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.datatypeeditor.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.AbstractSaveAsWizard;
import org.eclipse.fordiac.ide.application.wizards.SaveAsWizardPage;
import org.eclipse.fordiac.ide.datatypeeditor.editors.DataTypeEditor;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SaveAsStructTypeWizard
extends AbstractSaveAsWizard {
    private final StructuredType structuredType;
    private final IProject project;
    private final String oldEditorName;
    private final DataTypeEditor dataTypeEditor;

    public SaveAsStructTypeWizard(StructuredType structuredType, DataTypeEditor dataTypeEditor) {
        this.setWindowTitle(Messages.SaveAsStructTypeWizard_WindowTitle);
        this.project = structuredType.getTypeEntry().getFile().getProject();
        this.structuredType = structuredType;
        this.dataTypeEditor = dataTypeEditor;
        this.oldEditorName = structuredType.getTypeEntry().getTypeName();
    }

    public void addPages() {
        StructuredSelection selection = new StructuredSelection((Object)this.project);
        this.newFilePage = SaveAsWizardPage.createSaveAsStructTypeWizardPage((String)Messages.SaveAsStructTypeWizard_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.structuredType.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean performFinish() {
        if (this.perform()) {
            if (TypeEntry.getTypeNameFromFile((IFile)this.getTargetTypeFile()).equalsIgnoreCase(this.oldEditorName)) {
                this.dataTypeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                IFile targetFile = this.persistNewType();
                if (this.newFilePage.getOpenType()) {
                    OpenStructMenu.openStructEditor((IFile)targetFile);
                    this.closeOldEditor();
                }
            }
        }
        return true;
    }

    protected boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ConvertToStructHandler_ErrorTitle, (String)Messages.ConvertToStructHandler_ErrorMessage);
    }

    protected IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(this.newFilePage.getContainerFullPath()) + File.separator + this.newFilePage.getFileName() + ".DTP"));
    }

    private void closeOldEditor() {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            activePage.closeEditor(this.getCurrentOpenEditor().getEditor(false), false);
        }
    }

    private IEditorReference getCurrentOpenEditor() {
        return Arrays.stream(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences()).filter(editor -> editor.getName().equalsIgnoreCase(this.oldEditorName + ".DTP")).findAny().orElseThrow();
    }

    private IFile persistNewType() {
        final IFile targetFile = this.getTargetTypeFile();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)targetFile.getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                String newName = TypeEntry.getTypeNameFromFile((IFile)targetFile);
                StructuredType type = DataFactory.eINSTANCE.createStructuredType();
                type.setName(SaveAsStructTypeWizard.this.structuredType.getName());
                type.setComment(SaveAsStructTypeWizard.this.structuredType.getComment());
                InterfaceListCopier.copyVarList((Collection)type.getMemberVariables(), (Collection)SaveAsStructTypeWizard.this.structuredType.getMemberVariables(), (boolean)true);
                TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)type);
                type.setName(newName);
                SaveAsStructTypeWizard.this.createTypeEntry(targetFile).save((LibraryElement)type, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return targetFile;
    }

    private TypeEntry createTypeEntry(IFile targetTypeFile) {
        return TypeLibraryManager.INSTANCE.getTypeLibrary(this.project).createTypeEntry(targetTypeFile);
    }
}

