/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.builder.impl.javasupport.UnconfirmedStructuralChangesDelta;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class JdtQueuedBuildData
implements IQueuedBuildDataContribution {
    private Map<String, JavaBuilderState> javaBuildState;
    private Map<String, JavaBuilderState> javaBuildStateCopy;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltas;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltasCopy;

    @Override
    public void reset() {
        this.javaBuildState = new HashMap<String, JavaBuilderState>();
        this.unconfirmedDeltas = new ArrayList<UnconfirmedStructuralChangesDelta>();
    }

    @Override
    public void reset(IProject project) {
        this.javaBuildState.remove(project.getName());
    }

    public Collection<UnconfirmedStructuralChangesDelta> getUnconfirmedDeltas() {
        return this.unconfirmedDeltas;
    }

    @Override
    public boolean queueChange(IResourceDescription.Delta delta) {
        if (delta instanceof UnconfirmedStructuralChangesDelta) {
            UnconfirmedStructuralChangesDelta ucDelta = (UnconfirmedStructuralChangesDelta)delta;
            IProject project = ucDelta.getProject();
            JavaBuilderState state = this.javaBuildState.get(project.getName());
            if (state == null) {
                state = JavaBuilderState.getLastBuiltState((IProject)project);
                this.javaBuildState.put(project.getName(), state);
            }
            ucDelta.setBuildNumber(state.getBuildNumber());
            this.unconfirmedDeltas.add(ucDelta);
            return true;
        }
        return false;
    }

    @Override
    public boolean needsRebuild(IProject project, Collection<IResourceDescription.Delta> deltas) {
        JavaBuilderState oldState = this.javaBuildState.get(project.getName());
        JavaBuilderState newState = JavaBuilderState.getLastBuiltState((IProject)project);
        Object processor = oldState == null || oldState.getLastStructuralBuildTime() != newState.getLastStructuralBuildTime() ? delta -> {
            Set structurallyChangedTypes = newState.getStructurallyChangedTypes();
            if (this.namesIntersect(delta.getNew(), structurallyChangedTypes) || this.namesIntersect(delta.getOld(), structurallyChangedTypes)) {
                deltas.add((IResourceDescription.Delta)delta);
            }
        } : null;
        return this.doNeedRebuild(newState, (Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta>)processor);
    }

    protected boolean doNeedRebuild(JavaBuilderState javaBuilderState, Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta> processor) {
        Iterator<UnconfirmedStructuralChangesDelta> ucDeltas = this.unconfirmedDeltas.iterator();
        int buildNumber = javaBuilderState.getBuildNumber();
        IProject project = javaBuilderState.getProject();
        boolean result = false;
        while (ucDeltas.hasNext()) {
            UnconfirmedStructuralChangesDelta ucDelta = ucDeltas.next();
            if (!ucDelta.getProject().equals((Object)project)) continue;
            if (ucDelta.getBuildNumber() < buildNumber) {
                ucDeltas.remove();
                if (processor == null) continue;
                processor.apply((Object)ucDelta);
                continue;
            }
            result = true;
        }
        return result;
    }

    protected boolean namesIntersect(IResourceDescription resourceDescription, Set<QualifiedName> names) {
        if (resourceDescription == null) {
            return false;
        }
        for (IEObjectDescription objectDescription : resourceDescription.getExportedObjects()) {
            if (!names.contains(objectDescription.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createCheckpoint() {
        this.javaBuildStateCopy = new HashMap<String, JavaBuilderState>(this.javaBuildState);
        this.unconfirmedDeltasCopy = new ArrayList<UnconfirmedStructuralChangesDelta>(this.unconfirmedDeltas);
    }

    @Override
    public void discardCheckpoint() {
        this.javaBuildStateCopy = null;
        this.unconfirmedDeltasCopy = null;
    }

    @Override
    public void rollback() {
        this.javaBuildState.clear();
        this.javaBuildState.putAll(this.javaBuildStateCopy);
        this.unconfirmedDeltas.clear();
        this.unconfirmedDeltas.addAll(this.unconfirmedDeltasCopy);
    }
}

