/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameElementRefactoringProcessor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RenameElementRefactoringWizardPage
extends UserInputWizardPage {
    private final RenameElementRefactoringProcessor processor;
    private Text nameText;

    public RenameElementRefactoringWizardPage(RenameElementRefactoringProcessor processor) {
        super(processor.getProcessorName());
        this.processor = processor;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.initializeDialogUnits((Control)composite);
        this.createNameField(composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    protected void createNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(Messages.RenameElementRefactoringWizardPage_Name);
        this.nameText = new Text(parent, 2048);
        this.nameText.setText(Objects.requireNonNullElse(this.processor.getNewName(), ""));
        this.nameText.addModifyListener(e -> {
            this.processor.setNewName(this.nameText.getText());
            this.validatePage();
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.nameText.setFocus();
        }
        super.setVisible(visible);
    }

    protected void validatePage() {
        try {
            this.setPageComplete(this.processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException | OperationCanceledException e) {
            this.setPageComplete(RefactoringStatus.createFatalErrorStatus((String)e.getMessage()));
        }
    }
}

