/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands.RepairBrokenConnectionCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class SystemRepairBrokenConnectionChange
extends AbstractCommandChange<AutomationSystem> {
    private final URI structURI;
    private final Map<String, String> replaceableConMap;
    private final List<URI> list;
    private final boolean isSource;

    public SystemRepairBrokenConnectionChange(URI elementURI, URI structURI, Map<String, String> replaceableConMap, List<URI> list, boolean isSource) {
        super(Objects.requireNonNull(elementURI).trimFileExtension().lastSegment() + Messages.RepairBrokenConnectionChange_Name, elementURI, AutomationSystem.class);
        this.structURI = Objects.requireNonNull(structURI);
        this.replaceableConMap = Objects.requireNonNull(replaceableConMap);
        this.list = Objects.requireNonNull(list);
        this.isSource = isSource;
    }

    @Override
    public void initializeValidationData(AutomationSystem element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(AutomationSystem element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.list.forEach(uri -> {
            if (!uri.toPlatformString(true).equals(this.getElementURI().toPlatformString(true))) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(uri) + Messages.ConnectionsToStructRefactoring_FBNotInSystem + String.valueOf(this.getElementURI()))));
            }
        });
        return status;
    }

    @Override
    protected Command createCommand(AutomationSystem element) {
        CompoundCommand cmd = new CompoundCommand();
        LibraryElement libraryElement = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.structURI).getType();
        if (libraryElement instanceof StructuredType) {
            StructuredType structType = (StructuredType)libraryElement;
            this.list.forEach(uri -> {
                EObject eObject = element.eResource().getEObject(uri.fragment());
                if (eObject instanceof FBNetworkElement) {
                    Function<Connection, String> connectToVar;
                    Stream connections;
                    FBNetworkElement fbnelem = (FBNetworkElement)eObject;
                    Stream errormarkers = fbnelem.getInterface().getErrorMarker().stream();
                    if (this.isSource) {
                        connections = errormarkers.filter(err -> this.replaceableConMap.containsKey(err.getName())).map(IInterfaceElement::getOutputConnections).flatMap(Collection::stream);
                        connectToVar = t -> t.getSource().getName();
                    } else {
                        connections = errormarkers.filter(err -> this.replaceableConMap.containsValue(err.getName())).map(IInterfaceElement::getInputConnections).flatMap(Collection::stream);
                        connectToVar = t -> (String)this.replaceableConMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(t.getDestination().getName())).findAny().get().getKey();
                    }
                    connections.forEach(con -> cmd.add((Command)new RepairBrokenConnectionCommand((Connection)con, this.isSource, structType, (String)connectToVar.apply((Connection)con))));
                }
            });
        }
        return cmd;
    }
}

