% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{Det}
\alias{Det}
\title{Determinant of a Square Matrix}
\usage{
Det(
  X,
  method = c("elimination", "eigenvalues", "cofactors"),
  verbose = FALSE,
  fractions = FALSE,
  ...
)
}
\arguments{
\item{X}{a square matrix}

\item{method}{one of `"elimination"` (the default), `"eigenvalues"`, or `"cofactors"` (for computation by minors and cofactors)}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers, using the \code{\link[MASS]{fractions}} 
function; if you require greater accuracy, you can set the \code{cycles} (default 10)
and/or \code{max.denominator} (default 2000) arguments to \code{fractions} as a global option, e.g.,
\code{options(fractions=list(cycles=100, max.denominator=10^4))}.}

\item{...}{arguments passed to \code{\link{gaussianElimination}} or \code{\link{Eigen}}}
}
\value{
the determinant of \code{X}
}
\description{
Returns the determinant of a square matrix \code{X},
computed either by Gaussian elimination, expansion by cofactors, or as the product of the eigenvalues of the matrix.
If the latter, \code{X} must be symmetric.
}
\examples{
A <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
A
Det(A)
Det(A, verbose=TRUE, fractions=TRUE)
B <- matrix(1:9, 3, 3) # a singular matrix
B
Det(B)
C <- matrix(c(1, .5, .5, 1), 2, 2) # square, symmetric, nonsingular
Det(C)
Det(C, method="eigenvalues")
Det(C, method="cofactors")
}
\seealso{
\code{\link[base]{det}} for the base R function

\code{\link{gaussianElimination}}, \code{\link{Eigen}}

Other determinants: 
\code{\link{adjoint}()},
\code{\link{cofactor}()},
\code{\link{minor}()},
\code{\link{rowCofactors}()},
\code{\link{rowMinors}()}
}
\author{
John Fox
}
\concept{determinants}
