/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H_
#define _SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H_

#include <stdint.h>

#define AOSS_CC_BASE			0x0C2A0000
#define QSPI_BASE			0x088DC000
#define TLMM_TILE_BASE			0x0F100000

/* X1P42100 QSPI GPIO PINS */
#define QSPI_CS				GPIO(132)
#define QSPI_DATA_0			GPIO(128)
#define QSPI_DATA_1			GPIO(129)
#define QSPI_CLK			GPIO(127)

#define GPIO_FUNC_QSPI_DATA_0		GPIO128_FUNC_QSPI0_DATA_0
#define GPIO_FUNC_QSPI_DATA_1		GPIO129_FUNC_QSPI0_DATA_1
#define GPIO_FUNC_QSPI_CLK		GPIO127_FUNC_QSPI0_CLK

/*
 * QUP SERIAL ENGINE BASE ADDRESSES
 */
/* QUPV3_0 */
#define QUP_SERIAL0_BASE		0x00B80000
#define QUP_SERIAL1_BASE		0x00B84000
#define QUP_SERIAL2_BASE		0x00B88000
#define QUP_SERIAL3_BASE		0x00B8C000
#define QUP_SERIAL4_BASE		0x00B90000
#define QUP_SERIAL5_BASE		0x00B94000
#define QUP_SERIAL6_BASE		0x00B98000
#define QUP_SERIAL7_BASE		0x00B9C000
#define QUP_WRAP0_BASE			0x00BC0000
#define QUP_0_GSI_BASE			0x00B04000

/* QUPV3_1 */
#define QUP_SERIAL8_BASE		0x00A80000
#define QUP_SERIAL9_BASE		0x00A84000
#define QUP_SERIAL10_BASE		0x00A88000
#define QUP_SERIAL11_BASE		0x00A8C000
#define QUP_SERIAL12_BASE		0x00A90000
#define QUP_SERIAL13_BASE		0x00A94000
#define QUP_SERIAL14_BASE		0x00A98000
#define QUP_SERIAL15_BASE		0x00A9C000
#define QUP_WRAP1_BASE			0x00AC0000
#define QUP_1_GSI_BASE			0x00A04000

/* QUPV3_2 */
#define QUP_SERIAL16_BASE		0x00880000
#define QUP_SERIAL17_BASE		0x00884000
#define QUP_SERIAL18_BASE		0x00888000
#define QUP_SERIAL19_BASE		0x0088C000
#define QUP_SERIAL20_BASE		0x00890000
#define QUP_SERIAL21_BASE		0x00894000
#define QUP_SERIAL22_BASE		0x00898000
#define QUP_SERIAL23_BASE		0x0089C000
#define QUP_WRAP2_BASE			0x008C0000
#define QUP_2_GSI_BASE			0x00804000

#endif /*  __SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H__ */
