/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions;

import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultCachedModuleVersionList;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleVersionsCache
implements ModuleVersionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModuleVersionsCache.class);
    protected final BuildCommencedTimeProvider timeProvider;

    public AbstractModuleVersionsCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public void cacheModuleVersionList(ModuleComponentRepository<?> repository, ModuleIdentifier moduleId, Set<String> listedVersions) {
        LOGGER.debug("Caching version list in module versions cache: Using '{}' for '{}'", listedVersions, (Object)moduleId);
        ModuleAtRepositoryKey key = this.createKey(repository, moduleId);
        ModuleVersionsCacheEntry entry = this.createEntry(listedVersions);
        this.store(key, entry);
    }

    @Override
    public ModuleVersionsCache.CachedModuleVersionList getCachedModuleResolution(ModuleComponentRepository<?> repository, ModuleIdentifier moduleId) {
        ModuleAtRepositoryKey key = this.createKey(repository, moduleId);
        ModuleVersionsCacheEntry entry = this.get(key);
        return entry == null ? null : this.versionList(entry);
    }

    private ModuleVersionsCache.CachedModuleVersionList versionList(ModuleVersionsCacheEntry entry) {
        return new DefaultCachedModuleVersionList(entry.moduleVersionListing, this.timeProvider.getCurrentTime() - entry.createTimestamp);
    }

    private ModuleAtRepositoryKey createKey(ModuleComponentRepository<?> repository, ModuleIdentifier moduleId) {
        return new ModuleAtRepositoryKey(repository.getId(), moduleId);
    }

    private ModuleVersionsCacheEntry createEntry(Set<String> listedVersions) {
        return new ModuleVersionsCacheEntry(listedVersions, this.timeProvider.getCurrentTime());
    }

    protected abstract void store(ModuleAtRepositoryKey var1, ModuleVersionsCacheEntry var2);

    protected abstract ModuleVersionsCacheEntry get(ModuleAtRepositoryKey var1);
}

