/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.services;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.jspecify.annotations.Nullable;

public class ProviderBackedToolchainConfiguration
implements ToolchainConfiguration {
    private final ProviderFactory providerFactory;
    private final SystemProperties systemProperties;

    @Inject
    public ProviderBackedToolchainConfiguration(ProviderFactory providerFactory) {
        this(providerFactory, SystemProperties.getInstance());
    }

    ProviderBackedToolchainConfiguration(ProviderFactory providerFactory, SystemProperties systemProperties) {
        this.providerFactory = providerFactory;
        this.systemProperties = systemProperties;
    }

    public Collection<String> getJavaInstallationsFromEnvironment() {
        return Arrays.asList(((String)this.providerFactory.gradleProperty("org.gradle.java.installations.fromEnv").getOrElse((Object)"")).split(","));
    }

    public void setJavaInstallationsFromEnvironment(Collection<String> installations) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getInstallationsFromPaths() {
        return Arrays.asList(((String)this.providerFactory.gradleProperty("org.gradle.java.installations.paths").getOrElse((Object)"")).split(","));
    }

    public void setInstallationsFromPaths(Collection<String> installations) {
        throw new UnsupportedOperationException();
    }

    public boolean isAutoDetectEnabled() {
        return (Boolean)this.providerFactory.gradleProperty("org.gradle.java.installations.auto-detect").map(Boolean::parseBoolean).getOrElse((Object)Boolean.TRUE);
    }

    public void setAutoDetectEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public boolean isDownloadEnabled() {
        return (Boolean)this.providerFactory.gradleProperty("org.gradle.java.installations.auto-download").map(Boolean::parseBoolean).getOrElse((Object)Boolean.TRUE);
    }

    public void setDownloadEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public File getAsdfDataDirectory() {
        String asdfEnvVar = (String)this.providerFactory.environmentVariable("ASDF_DATA_DIR").getOrNull();
        if (asdfEnvVar != null) {
            return new File(asdfEnvVar);
        }
        return new File(this.systemProperties.getUserHome(), ".asdf");
    }

    public File getIntelliJdkDirectory() {
        return (File)this.providerFactory.gradleProperty("org.gradle.java.installations.idea-jdks-directory").map(File::new).getOrElse((Object)this.defaultJdksDirectory(OperatingSystem.current()));
    }

    public void setIntelliJdkDirectory(File intellijInstallationDirectory) {
        throw new UnsupportedOperationException();
    }

    private File defaultJdksDirectory(OperatingSystem os) {
        if (os.isMacOsX()) {
            return new File(this.systemProperties.getUserHome(), "Library/Java/JavaVirtualMachines");
        }
        return new File(this.systemProperties.getUserHome(), ".jdks");
    }

    public File getJabbaHomeDirectory() {
        String jabbaHome = (String)this.providerFactory.environmentVariable("JABBA_HOME").getOrNull();
        if (jabbaHome != null) {
            return new File(jabbaHome);
        }
        return null;
    }

    public File getSdkmanCandidatesDirectory() {
        String asdfEnvVar = (String)this.providerFactory.environmentVariable("SDKMAN_CANDIDATES_DIR").getOrNull();
        if (asdfEnvVar != null) {
            return new File(asdfEnvVar);
        }
        return new File(this.systemProperties.getUserHome(), ".sdkman/candidates");
    }

    public @Nullable String getEnvironmentVariableValue(String variableName) {
        return (String)this.providerFactory.environmentVariable(variableName).getOrNull();
    }
}

