/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Scanner;
import java.util.concurrent.Executor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.process.internal.StreamsHandler;

public class DaemonOutputConsumer
implements StreamsHandler {
    private static final Logger LOGGER = Logging.getLogger(DaemonOutputConsumer.class);
    DaemonStartupCommunication startupCommunication = new DaemonStartupCommunication();
    private String processOutput;
    private InputStream processStdOutput;

    public void connectStreams(Process process, String processName, Executor executor) {
        this.processStdOutput = process.getInputStream();
    }

    public void start() {
        if (this.processStdOutput == null) {
            throw new IllegalStateException("Cannot start consuming daemon output because streams have not been connected first.");
        }
        LOGGER.debug("Starting consuming the daemon process output.");
        StringWriter output = new StringWriter();
        try (Scanner scanner = new Scanner(this.processStdOutput);){
            PrintWriter printer = new PrintWriter(output);
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                LOGGER.debug("daemon out: {}", (Object)line);
                printer.println(line);
                if (!this.startupCommunication.containsGreeting(line)) continue;
                break;
            }
        }
        this.processOutput = output.toString();
    }

    public String getProcessOutput() {
        if (this.processOutput == null) {
            throw new IllegalStateException("Unable to get process output as consuming has not finished yet.");
        }
        return this.processOutput;
    }

    public void removeStartupContext() {
    }

    public void stop() {
    }

    public void disconnect() {
    }
}

