/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleMetadataCache;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.lower.StaticMembersLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020'H\u0016J@\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002J \u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J-\u0010<\u001a\u00020\u001e2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010=\u001a\u00020,2\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010@\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020BH\u0016J \u0010C\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\u0006\u0010D\u001a\u0002062\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010E\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020FH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmModuleTypeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;", "wasmModuleMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;", "allowIncompleteImplementations", "", "skipCommentInstructions", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;ZZ)V", "optimiseLambdaVirtualCalls", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "unitPrimaryConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getUnitPrimaryConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "unitPrimaryConstructor$delegate", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitProperty", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createVirtualTableStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "methods", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VirtualMethodMetadata;", "name", "", "superType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "isFinal", "generateSpecialITableField", "buildSpecialITableInit", "metadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "builder", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "createVTable", "addInterfaceMethod", "method", "addInterfaceMethod$backend_wasm", "createRtti", "createClassITable", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceTable", "classMetadata", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilderKt\n*L\n1#1,670:1\n1563#2:671\n1634#2,3:672\n1634#2,3:676\n1617#2,9:679\n1869#2:688\n1870#2:690\n1626#2:691\n1563#2:692\n1634#2,3:693\n1740#2,3:696\n295#2,2:699\n1878#2,3:703\n827#2:712\n855#2,2:713\n1634#2,3:716\n3301#2,10:719\n1#3:675\n1#3:689\n326#4,2:701\n328#4:706\n326#4,3:707\n326#4,2:710\n328#4:715\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n*L\n90#1:671\n90#1:672,3\n225#1:676,3\n250#1:679,9\n250#1:688\n250#1:690\n250#1:691\n251#1:692\n251#1:693,3\n253#1:696,3\n275#1:699,2\n324#1:703,3\n425#1:712\n425#1:713,2\n491#1:716,3\n524#1:719,10\n250#1:689\n321#1:701,2\n321#1:706\n384#1:707,3\n422#1:710,2\n422#1:715\n*E\n"})
public final class DeclarationGenerator
extends IrVisitorVoid {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final WasmModuleTypeTransformer wasmModuleTypeTransformer;
    @NotNull
    private final WasmModuleMetadataCache wasmModuleMetadataCache;
    private final boolean allowIncompleteImplementations;
    private final boolean skipCommentInstructions;
    private final boolean optimiseLambdaVirtualCalls;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;
    @NotNull
    private final Lazy unitPrimaryConstructor$delegate;

    public DeclarationGenerator(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext, @NotNull WasmModuleTypeTransformer wasmModuleTypeTransformer, @NotNull WasmModuleMetadataCache wasmModuleMetadataCache, boolean allowIncompleteImplementations, boolean skipCommentInstructions) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFileCodegenContext, (String)"wasmFileCodegenContext");
        Intrinsics.checkNotNullParameter((Object)wasmModuleTypeTransformer, (String)"wasmModuleTypeTransformer");
        Intrinsics.checkNotNullParameter((Object)wasmModuleMetadataCache, (String)"wasmModuleMetadataCache");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.wasmModuleTypeTransformer = wasmModuleTypeTransformer;
        this.wasmModuleMetadataCache = wasmModuleMetadataCache;
        this.allowIncompleteImplementations = allowIncompleteImplementations;
        this.skipCommentInstructions = skipCommentInstructions;
        this.optimiseLambdaVirtualCalls = this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_OPTIMISE_LAMBDA_CALLS);
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitGetInstanceFunction_delegate$lambda$0(this));
        this.unitPrimaryConstructor$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitPrimaryConstructor_delegate$lambda$1(this));
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrConstructor getUnitPrimaryConstructor() {
        Lazy lazy = this.unitPrimaryConstructor$delegate;
        return (IrConstructor)lazy.getValue();
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isExternal()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        String nameIfExported;
        WasmImportDescriptor importedName;
        WasmImportDescriptor wasmImportDescriptor;
        void $this$mapTo$iv$iv;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrConstructor && (this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(declaration)) || AnnotationsKt.hasWasmPrimitiveConstructorAnnotation(declaration))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(declaration) || AnnotationsKt.getWasmOpAnnotation(declaration) != null;
        if (isIntrinsic) {
            return;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride(declaration)) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration);
        IrFunction irFunction = declaration;
        WasmType resultType = Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitGetInstanceFunction()) || Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitPrimaryConstructor()) ? this.wasmModuleTypeTransformer.transformType(declaration.getReturnType()) : this.wasmModuleTypeTransformer.transformResultType(declaration.getReturnType());
        Iterable $this$map$iv22 = irParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.wasmModuleTypeTransformer.transformValueParameterType((IrValueParameter)it));
        }
        List list = CollectionsKt.listOfNotNull((Object)resultType);
        List list2 = (List)destination$iv$iv;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(list2, list);
        this.wasmFileCodegenContext.defineFunctionType(declaration.getSymbol(), wasmFunctionType);
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getModality() == Modality.ABSTRACT) {
            return;
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)declaration, (Object)IrResolveUtilsKt.getRealOverrideTarget(declaration));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        WasmSymbol<WasmFunctionType> functionTypeSymbol = this.wasmFileCodegenContext.referenceFunctionType(declaration.getSymbol());
        WasmImportDescriptor wasmImportModule = AnnotationsKt.getWasmImportDescriptor(declaration);
        String jsCode = AnnotationsKt.getJsFunAnnotation(declaration);
        if (wasmImportModule != null) {
            if (!declaration.isExternal()) {
                boolean $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = false;
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = "Non-external fun with @WasmImport " + IrUtilsKt.getFqNameWhenAvailable(declaration);
                throw new IllegalStateException($i$a$-check-DeclarationGenerator$visitFunction$importedName$22.toString());
            }
            this.wasmFileCodegenContext.addJsModuleImport(declaration.getSymbol(), wasmImportModule.getModuleName());
            wasmImportDescriptor = wasmImportModule;
        } else if (jsCode != null) {
            if (!(declaration instanceof IrSimpleFunction)) {
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-check-DeclarationGenerator$visitFunction$importedName$22.toString());
            }
            WasmSymbol<String> jsFunName = new WasmSymbol<String>(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration)));
            this.wasmFileCodegenContext.addJsFun(((IrSimpleFunction)declaration).getSymbol(), jsFunName, jsCode);
            wasmImportDescriptor = new WasmImportDescriptor("js_code", (WasmSymbolReadOnly<String>)jsFunName);
        } else {
            wasmImportDescriptor = importedName = null;
        }
        if (importedName != null) {
            this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), new WasmFunction.Imported(watName, (WasmSymbolReadOnly<WasmFunctionType>)functionTypeSymbol, importedName));
            return;
        }
        IrElement locationTarget = DeclarationGeneratorKt.getLocationTarget(declaration);
        SourceLocation functionStartLocation = LocationUtilsKt.getSourceLocation$default(locationTarget, declaration.getSymbol(), IrUtilsKt.getFileOrNull(declaration), null, 4, null);
        SourceLocation functionEndLocation = LocationUtilsKt.getSourceLocation(locationTarget, declaration.getSymbol(), IrUtilsKt.getFileOrNull(declaration), LocationType.END);
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, functionTypeSymbol, null, null, functionStartLocation, functionEndLocation, 12, null);
        WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(declaration, function2, this.backendContext, this.wasmFileCodegenContext, this.wasmModuleTypeTransformer, this.skipCommentInstructions);
        for (IrValueParameter irParameter : irParameters) {
            functionCodegenContext.defineLocal(irParameter.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(this.backendContext, this.wasmFileCodegenContext, functionCodegenContext, this.wasmModuleMetadataCache, this.wasmModuleTypeTransformer);
        IrBody declarationBody = declaration.getBody();
        if (!(declarationBody instanceof IrBlockBody)) {
            boolean bl3 = false;
            String string = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string.toString());
        }
        if (declaration instanceof IrConstructor) {
            bodyBuilder.generateObjectCreationPrefixIfNeeded((IrConstructor)declaration);
        }
        IrVisitorsKt.acceptVoid((IrElement)declarationBody, bodyBuilder);
        if (declaration instanceof IrConstructor) {
            exprGen.buildGetLocal(function2.getLocals().get(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
            exprGen.buildInstr(WasmOp.RETURN, SourceLocation.Companion.NoLocation("Implicit return from constructor"), new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            LocationUtilsKt.buildUnreachableForVerifier(exprGen);
        }
        this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), function2);
        String string = nameIfExported = AnnotationUtilsKt.isJsExport(declaration) ? AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier() : AnnotationsKt.getWasmExportNameIfWasmExport(declaration);
        if (nameIfExported != null) {
            this.wasmFileCodegenContext.addExport(new WasmExport.Function(nameIfExported, function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WasmStructDeclaration createVirtualTableStruct(List<VirtualMethodMetadata> methods2, String name2, WasmSymbolReadOnly<? extends WasmTypeDeclaration> superType, boolean isFinal, boolean generateSpecialITableField) {
        List vtableFields = new ArrayList();
        if (generateSpecialITableField) {
            WasmStructFieldDeclaration specialITableField = new WasmStructFieldDeclaration("<SpecialITable>", new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getInterfaceTableTypes().getSpecialSlotITableType())), false);
            vtableFields.add(specialITableField);
        }
        Iterable $this$mapTo$iv = methods2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            Collection collection = vtableFields;
            boolean bl = false;
            String string = it.getSignature().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            collection.add(new WasmStructFieldDeclaration(string, new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceFunctionType(it.getFunction().getSymbol()))), false));
        }
        return new WasmStructDeclaration(name2, vtableFields, superType, isFinal);
    }

    static /* synthetic */ WasmStructDeclaration createVirtualTableStruct$default(DeclarationGenerator declarationGenerator, List list, String string, WasmSymbolReadOnly wasmSymbolReadOnly, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            wasmSymbolReadOnly = null;
        }
        return declarationGenerator.createVirtualTableStruct(list, string, wasmSymbolReadOnly, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSpecialITableInit(ClassMetadata metadata, WasmExpressionBuilder builder, SourceLocation location) {
        Iterator<Object> $this$mapTo$iv$iv;
        List list;
        Object element$iv$iv$iv;
        Iterable destination$iv$iv;
        IrClass klass = metadata.getKlass();
        if (!ClassInfoKt.hasInterfaceSuperClass(klass)) {
            builder.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
            return;
        }
        List<IrClass> supportedIFaces = metadata.getInterfaces();
        List<IrClassSymbol> specialSlotITableTypes = this.backendContext.getSpecialSlotITableTypes$backend_wasm();
        if (this.optimiseLambdaVirtualCalls) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = supportedIFaces;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrClass p0 = (IrClass)element$iv$iv;
                boolean bl2 = false;
                if (UtilsKt.getFunctionInvokeMethod(p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List invokeFunctions = list;
        Iterable $this$map$iv = specialSlotITableTypes;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator $i$f$forEach = $this$mapTo$iv$iv.iterator();
        while ($i$f$forEach.hasNext()) {
            void iFace;
            void bl;
            Object item$iv$iv = $i$f$forEach.next();
            element$iv$iv$iv = (IrClassSymbol)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            void it = bl = iFace;
            boolean bl5 = false;
            collection.add(supportedIFaces.contains(it.getOwner()) ? bl : null);
        }
        List specialInterfacesIfSupported = (List)destination$iv$iv2;
        if (invokeFunctions.isEmpty()) {
            boolean bl;
            block20: {
                Iterable $this$all$iv = specialInterfacesIfSupported;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    $this$mapTo$iv$iv = $this$all$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        IrClassSymbol it = (IrClassSymbol)element$iv;
                        boolean bl6 = false;
                        if (it == null) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                builder.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
                return;
            }
        }
        for (IrClassSymbol supportedSpecialInterface : specialInterfacesIfSupported) {
            if (supportedSpecialInterface != null) {
                for (VirtualMethodMetadata method : this.wasmModuleMetadataCache.getInterfaceMetadata(supportedSpecialInterface).getMethods()) {
                    this.addInterfaceMethod$backend_wasm(metadata, builder, method, location);
                }
                builder.buildStructNew(this.wasmFileCodegenContext.referenceVTableGcType(supportedSpecialInterface), location);
                continue;
            }
            builder.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        }
        if (!((Collection)invokeFunctions).isEmpty()) {
            $this$mapTo$iv$iv = ((Iterable)invokeFunctions).iterator();
            if (!$this$mapTo$iv$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            IrSimpleFunction it22 = (IrSimpleFunction)$this$mapTo$iv$iv.next();
            boolean bl = false;
            int it22 = it22.getParameters().size();
            while ($this$mapTo$iv$iv.hasNext()) {
                IrSimpleFunction it32 = (IrSimpleFunction)$this$mapTo$iv$iv.next();
                $i$a$-maxOf-DeclarationGenerator$buildSpecialITableInit$functionsITableSize$1 = false;
                int it32 = it32.getParameters().size();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int functionsITableSize = it22;
            for (int i2 = 0; i2 < functionsITableSize; ++i2) {
                Object v2;
                block21: {
                    int slotIndex = i2;
                    boolean bl7 = false;
                    int currentParameterCount = slotIndex + 1;
                    Iterable $this$firstOrNull$iv = invokeFunctions;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        IrSimpleFunction it = (IrSimpleFunction)element$iv;
                        boolean bl8 = false;
                        if (!(it.getParameters().size() == currentParameterCount)) continue;
                        v2 = element$iv;
                        break block21;
                    }
                    v2 = null;
                }
                IrSimpleFunction invokeFunction = v2;
                if (invokeFunction != null) {
                    VirtualMethodMetadata method = new VirtualMethodMetadata(invokeFunction, ClassInfoKt.wasmSignature(invokeFunction, this.irBuiltIns));
                    this.addInterfaceMethod$backend_wasm(metadata, builder, method, location);
                    continue;
                }
                builder.buildRefNull(WasmHeapType.Simple.Func.INSTANCE, location);
            }
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.wasmFileCodegenContext.getInterfaceTableTypes().getWasmFuncArrayType()), new WasmImmediate.ConstI32(functionsITableSize)};
            builder.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, wasmImmediateArray);
        } else {
            builder.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        }
        builder.buildStructNew(this.wasmFileCodegenContext.getInterfaceTableTypes().getSpecialSlotITableType(), location);
    }

    /*
     * WARNING - void declaration
     */
    private final void createVTable(ClassMetadata metadata) {
        WasmSymbol<WasmTypeDeclaration> wasmSymbol;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol = klass.getSymbol();
        DeclarationGenerator declarationGenerator = this;
        List<VirtualMethodMetadata> list = metadata.getVirtualMethods();
        String string = "<classVTable>";
        Object object = metadata.getSuperClass();
        if (object != null && (object = ((ClassMetadata)object).getKlass()) != null && (object = ((IrClass)object).getSymbol()) != null) {
            void p0;
            Object object2 = object;
            WasmFileCodegenContext wasmFileCodegenContext = this.wasmFileCodegenContext;
            Object object3 = object2;
            String string2 = string;
            List<VirtualMethodMetadata> list2 = list;
            DeclarationGenerator declarationGenerator2 = declarationGenerator;
            boolean bl = false;
            WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = wasmFileCodegenContext.referenceVTableGcType((IrClassSymbol)p0);
            declarationGenerator = declarationGenerator2;
            list = list2;
            string = string2;
            wasmSymbol = wasmSymbol2;
        } else {
            wasmSymbol = null;
        }
        WasmStructDeclaration vtableStruct = declarationGenerator.createVirtualTableStruct(list, string, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmSymbol, klass.getModality() == Modality.FINAL, true);
        this.wasmFileCodegenContext.defineVTableGcType(metadata.getKlass().getSymbol(), vtableStruct);
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        WasmSymbol<WasmTypeDeclaration> vTableTypeReference = this.wasmFileCodegenContext.referenceVTableGcType(symbol);
        WasmRefType vTableRefGcType = new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)vTableTypeReference));
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createVTable_u24lambda_u2416 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of vtable struct");
        this.buildSpecialITableInit(metadata, $this$createVTable_u24lambda_u2416, location);
        Iterable $this$forEachIndexed$iv = metadata.getVirtualMethods();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void method;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            int i2 = n2;
            boolean bl2 = false;
            if (method.getFunction().getModality() != Modality.ABSTRACT) {
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(this.wasmFileCodegenContext.referenceFunction(method.getFunction().getSymbol()))};
                $this$createVTable_u24lambda_u2416.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray);
                continue;
            }
            if (!this.allowIncompleteImplementations) {
                boolean bl3 = false;
                String string3 = "Cannot find class implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(klass);
                throw new IllegalStateException(string3.toString());
            }
            $this$createVTable_u24lambda_u2416.buildRefNull(WasmHeapType.Simple.NoFunc.INSTANCE, location);
        }
        $this$createVTable_u24lambda_u2416.buildStructNew(vTableTypeReference, location);
        List initVTableGlobal = res$iv;
        this.wasmFileCodegenContext.defineGlobalVTable(symbol, new WasmGlobal("<classVTable>", vTableRefGcType, false, initVTableGlobal, null, 16, null));
    }

    public final void addInterfaceMethod$backend_wasm(@NotNull ClassMetadata metadata, @NotNull WasmExpressionBuilder builder, @NotNull VirtualMethodMetadata method, @NotNull SourceLocation location) {
        Object v0;
        WasmImmediate[] wasmImmediateArray;
        IrClass klass;
        block4: {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            klass = metadata.getKlass();
            wasmImmediateArray = (WasmImmediate[])metadata.getVirtualMethods();
            for (Object t2 : wasmImmediateArray) {
                VirtualMethodMetadata it = (VirtualMethodMetadata)t2;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getSignature(), (Object)method.getSignature()) && it.getFunction().getModality() != Modality.ABSTRACT)) continue;
                v0 = t2;
                break block4;
            }
            v0 = null;
        }
        VirtualMethodMetadata classMethod = v0;
        if (classMethod == null && !this.allowIncompleteImplementations && !this.backendContext.getPartialLinkageSupport().isEnabled()) {
            throw new IllegalStateException(("Cannot find interface implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(klass)).toString());
        }
        if (classMethod != null) {
            WasmSymbol<WasmFunction> functionTypeReference = this.wasmFileCodegenContext.referenceFunction(classMethod.getFunction().getSymbol());
            wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(functionTypeReference)};
            builder.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray);
        } else {
            builder.buildRefNull(WasmHeapType.Simple.NoFunc.INSTANCE, location);
        }
    }

    private final void createRtti(ClassMetadata metadata) {
        Object object;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol = klass.getSymbol();
        IrClass irClass = ClassInfoKt.getSuperClass(klass, this.irBuiltIns);
        IrClassSymbol superType = irClass != null ? irClass.getSymbol() : null;
        boolean fqnShouldBeEmitted = CommonConfigurationKeysKt.getLanguageVersionSettings(this.backendContext.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            FqName fqName = StaticMembersLoweringKt.getOriginalFqName(klass);
            if (fqName == null) {
                fqName = AdditionalIrUtilsKt.getKotlinFqName(klass);
            }
            if ((object = FqNamesUtilKt.parentOrNull(fqName)) == null || (object = ((FqName)object).asString()) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        String qualifier = object;
        String string = klass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String simpleName = string;
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair = this.wasmFileCodegenContext.referenceStringLiteralAddressAndId(qualifier);
        WasmSymbol packageNameAddress = (WasmSymbol)pair.component1();
        WasmSymbol packageNamePoolId = (WasmSymbol)pair.component2();
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair2 = this.wasmFileCodegenContext.referenceStringLiteralAddressAndId(simpleName);
        WasmSymbol simpleNameAddress = (WasmSymbol)pair2.component1();
        WasmSymbol simpleNamePoolId = (WasmSymbol)pair2.component2();
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of rtti struct");
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createRtti_u24lambda_u2418 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        this.interfaceTable($this$createRtti_u24lambda_u2418, metadata, location);
        if (superType != null) {
            $this$createRtti_u24lambda_u2418.buildGetGlobal(this.wasmFileCodegenContext.referenceRttiGlobal(superType), location);
        } else {
            $this$createRtti_u24lambda_u2418.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        }
        $this$createRtti_u24lambda_u2418.buildConstI32Symbol(packageNameAddress, location);
        $this$createRtti_u24lambda_u2418.buildConstI32(qualifier.length(), location);
        $this$createRtti_u24lambda_u2418.buildConstI32Symbol(packageNamePoolId, location);
        $this$createRtti_u24lambda_u2418.buildConstI32Symbol(simpleNameAddress, location);
        $this$createRtti_u24lambda_u2418.buildConstI32(simpleName.length(), location);
        $this$createRtti_u24lambda_u2418.buildConstI32Symbol(simpleNamePoolId, location);
        $this$createRtti_u24lambda_u2418.buildConstI64(this.wasmFileCodegenContext.referenceTypeId(symbol), location);
        $this$createRtti_u24lambda_u2418.buildStructNew(this.wasmFileCodegenContext.getRttiType(), location);
        List initRttiGlobal = res$iv;
        WasmGlobal rttiGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable(klass) + "_rtti", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getRttiType())), false, initRttiGlobal, null, 16, null);
        this.wasmFileCodegenContext.defineRttiGlobal(rttiGlobal, symbol, superType);
    }

    /*
     * WARNING - void declaration
     */
    private final void createClassITable(ClassMetadata metadata) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        IrClass klass = metadata.getKlass();
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        if (!ClassInfoKt.hasInterfaceSuperClass(klass)) {
            return;
        }
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of itable struct");
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createClassITable_u24lambda_u2420 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        List<IrClass> supportedIFaces = metadata.getInterfaces();
        WasmImmediate[] wasmImmediateArray = supportedIFaces;
        boolean $i$f$filterNot = false;
        Iterator<VirtualMethodMetadata> iterator2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrClass it = (IrClass)element$iv$iv;
            boolean bl2 = false;
            if (this.backendContext.getSpecialSlotITableTypes$backend_wasm().contains(it.getSymbol()) || this.optimiseLambdaVirtualCalls && IrTypeUtilsKt.isFunction(it.getSymbol())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List regularITableIFaces = (List)destination$iv$iv;
        for (IrClass iFace : regularITableIFaces) {
            for (VirtualMethodMetadata method : this.wasmModuleMetadataCache.getInterfaceMetadata(iFace.getSymbol()).getMethods()) {
                this.addInterfaceMethod$backend_wasm(metadata, $this$createClassITable_u24lambda_u2420, method, location);
            }
            $this$createClassITable_u24lambda_u2420.buildStructNew(this.wasmFileCodegenContext.referenceVTableGcType(iFace.getSymbol()), location);
        }
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.wasmFileCodegenContext.getInterfaceTableTypes().getWasmAnyArrayType()), new WasmImmediate.ConstI32(regularITableIFaces.size())};
        $this$createClassITable_u24lambda_u2420.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, wasmImmediateArray);
        List initITableGlobal = res$iv;
        WasmGlobal wasmClassIFaceGlobal = new WasmGlobal("<classITable>", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getInterfaceTableTypes().getWasmAnyArrayType())), false, initITableGlobal, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalClassITable(klass.getSymbol(), wasmClassIFaceGlobal);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isExternal()) {
            return;
        }
        IrClassSymbol symbol = declaration.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation(declaration);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.wasmModuleTypeTransformer.transformFieldType(wasmArrayAnnotation.getType()), wasmArrayAnnotation.isMutable()));
            this.wasmFileCodegenContext.defineGcType(symbol, wasmArrayDeclaration);
            return;
        }
        String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration));
        if (IrUtilsKt.isInterface(declaration)) {
            WasmStructDeclaration vtableStruct = DeclarationGenerator.createVirtualTableStruct$default(this, this.wasmModuleMetadataCache.getInterfaceMetadata(symbol).getMethods(), "<classITable>", null, true, false, 4, null);
            this.wasmFileCodegenContext.defineVTableGcType(symbol, vtableStruct);
        } else {
            WasmSymbol<WasmTypeDeclaration> wasmSymbol;
            ClassMetadata metadata = this.wasmModuleMetadataCache.getClassMetadata(symbol);
            this.createVTable(metadata);
            this.createClassITable(metadata);
            this.createRtti(metadata);
            WasmRefType vtableRefGcType = new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceVTableGcType(symbol)));
            List fields2 = new ArrayList();
            fields2.add(new WasmStructFieldDeclaration("vtable", vtableRefGcType, false));
            fields2.add(new WasmStructFieldDeclaration("itable", new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getInterfaceTableTypes().getWasmAnyArrayType())), false));
            fields2.add(new WasmStructFieldDeclaration("rtti", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.getRttiType())), false));
            Iterable $this$mapTo$iv = ClassInfoKt.allFields(declaration, this.irBuiltIns);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrField irField = (IrField)item$iv;
                Collection collection = fields2;
                boolean bl = false;
                String string = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(new WasmStructFieldDeclaration(string, this.wasmModuleTypeTransformer.transformFieldType(it.getType()), true));
            }
            ClassMetadata superClass = metadata.getSuperClass();
            String string = nameStr;
            List list = fields2;
            ClassMetadata classMetadata = superClass;
            if (classMetadata != null) {
                Object item$iv;
                item$iv = classMetadata;
                List list2 = list;
                String string2 = string;
                boolean bl = false;
                WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = this.wasmFileCodegenContext.referenceGcType(superClass.getKlass().getSymbol());
                string = string2;
                list = list2;
                wasmSymbol = wasmSymbol2;
            } else {
                wasmSymbol = null;
            }
            boolean bl = declaration.getModality() == Modality.FINAL;
            WasmSymbolReadOnly wasmSymbolReadOnly = wasmSymbol;
            List list3 = list;
            String string3 = string;
            WasmStructDeclaration structType = new WasmStructDeclaration(string3, list3, wasmSymbolReadOnly, bl);
            this.wasmFileCodegenContext.defineGcType(symbol, structType);
        }
        for (IrDeclaration member : declaration.getDeclarations()) {
            IrVisitorsKt.acceptVoid((IrElement)member, this);
        }
    }

    private final void interfaceTable(WasmExpressionBuilder builder, ClassMetadata classMetadata, SourceLocation location) {
        List<IrClass> supportedInterfaces = classMetadata.getInterfaces();
        if (supportedInterfaces.isEmpty()) {
            builder.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
            return;
        }
        List<IrClassSymbol> specialSlotIFaces = this.backendContext.getSpecialSlotITableTypes$backend_wasm();
        Iterable $this$partition$iv = supportedInterfaces;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            IrClass it = (IrClass)element$iv;
            boolean bl = false;
            boolean bl2 = !specialSlotIFaces.contains(it.getSymbol()) && (!this.optimiseLambdaVirtualCalls || !IrTypeUtilsKt.isFunction(it.getSymbol())) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List forward = (List)pair.component1();
        List back = (List)pair.component2();
        List supportedPushedBack = CollectionsKt.plus((Collection)forward, (Iterable)back);
        for (IrClass iFace : supportedPushedBack) {
            builder.buildConstI64(this.wasmFileCodegenContext.referenceTypeId(iFace.getSymbol()), location);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.wasmFileCodegenContext.referenceGcType(this.backendContext.getWasmSymbols().getWasmLongImmutableArray$backend_wasm())), new WasmImmediate.ConstI32(supportedPushedBack.size())};
        builder.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, wasmImmediateArray);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrExpression initValue;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isStatic()) {
            return;
        }
        WasmType wasmType = this.wasmModuleTypeTransformer.transformType(declaration.getType());
        List initBody = new ArrayList();
        WasmExpressionBuilder wasmExpressionGenerator = new WasmExpressionBuilder(initBody, this.skipCommentInstructions);
        IrExpressionBody irExpressionBody = declaration.getInitializer();
        IrExpression irExpression = initValue = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (initValue != null) {
            if (initValue instanceof IrConst && !(((IrConst)initValue).getKind() instanceof IrConstKind.String)) {
                DeclarationGeneratorKt.generateConstExpression((IrConst)initValue, wasmExpressionGenerator, this.wasmFileCodegenContext, this.backendContext, LocationUtilsKt.getSourceLocation$default(initValue, declaration.getSymbol(), IrUtilsKt.getFileOrNull(declaration), null, 4, null));
            } else {
                WasmFunction.Defined stubFunction = new WasmFunction.Defined("static_fun_stub", new WasmSymbol(null, 1, null), null, null, null, null, 60, null);
                WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(null, stubFunction, this.backendContext, this.wasmFileCodegenContext, this.wasmModuleTypeTransformer, this.skipCommentInstructions);
                BodyGenerator bodyGenerator = new BodyGenerator(this.backendContext, this.wasmFileCodegenContext, functionCodegenContext, this.wasmModuleMetadataCache, this.wasmModuleTypeTransformer);
                bodyGenerator.generateExpression$backend_wasm(initValue);
                this.wasmFileCodegenContext.addFieldInitializer(declaration.getSymbol(), stubFunction.getInstructions(), IrJsUtilsKt.isObjectInstanceField(declaration));
                DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
            }
        } else {
            DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        }
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration)), wasmType, true, initBody, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalField(declaration.getSymbol(), global);
    }

    private static final IrSimpleFunction unitGetInstanceFunction_delegate$lambda$0(DeclarationGenerator this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.backendContext);
    }

    private static final IrConstructor unitPrimaryConstructor_delegate$lambda$1(DeclarationGenerator this$0) {
        return IrUtilsKt.getPrimaryConstructor((IrClass)this$0.backendContext.getIrBuiltIns().getUnitClass().getOwner());
    }
}

