// Do not manually edit this file.
// It has been autogenerated by generate_docstrings.py
use std::ffi::CStr;

pub(crate) const PYDANTIC_SCHEMA: &CStr = c"__get_pydantic_core_schema__(source_type, handler)\n--\n\n";
pub(crate) const DATE: &CStr = c"\
A date without a time component.

>>> d = Date(2021, 1, 2)
Date(\"2021-01-02\")

Can also be constructed directly from an ISO 8601 string.

>>> Date(\"2021-01-02\")
Date(\"2021-01-02\")
";
pub(crate) const DATEDELTA: &CStr = c"\
A duration of time consisting of calendar units
(years, months, weeks, and days)
";
pub(crate) const DATETIMEDELTA: &CStr = c"\
A duration with both a date and time component.";
pub(crate) const IMPLICITLYIGNORINGDST: &CStr = c"\
A calculation was performed that implicitly ignored DST";
pub(crate) const INSTANT: &CStr = c"\
Represents a moment in time with nanosecond precision.

This class is great for representing a specific point in time independent
of location. It maps 1:1 to UTC or a UNIX timestamp.

Example
-------
>>> from whenever import Instant
>>> py311_release = Instant.from_utc(2022, 10, 24, hour=17)
Instant(\"2022-10-24 17:00:00Z\")
>>> py311_release.add(hours=3).timestamp()
1666641600
";
pub(crate) const INVALIDOFFSETERROR: &CStr = c"\
A string has an invalid offset for the given zone";
pub(crate) const MONTHDAY: &CStr = c"\
A month and day without a year component.

Useful for representing recurring events or birthdays.

Example
-------
>>> MonthDay(11, 23)
MonthDay(\"--11-23\")
";
pub(crate) const OFFSETDATETIME: &CStr = c"\
A datetime with a fixed UTC offset.
Useful for representing a \"static\" local date and time-of-day
at a specific location.

Example
-------
>>> # Midnight in Salt Lake City
>>> OffsetDateTime(2023, 4, 21, offset=-6)
OffsetDateTime(\"2023-04-21 00:00:00-06:00\")

Note
----
Adjusting instances of this class do *not* account for daylight saving time.
If you need to add or subtract durations from an offset datetime
and account for DST, convert to a ``ZonedDateTime`` first,
This class knows when the offset changes.
";
pub(crate) const PLAINDATETIME: &CStr = c"\
A combination of date and time-of-day, without a timezone.

Can be used to represent local time, i.e. how time appears to people
on a wall clock.

It can't be mixed with exact time types (e.g. ``Instant``, ``ZonedDateTime``)
Conversion to exact time types can only be done by
explicitly assuming a timezone or offset.

Examples of when to use this type:

- You need to express a date and time as it would be observed locally
  on the \"wall clock\" or calendar.
- You receive a date and time without any timezone information,
  and you need a type to represent this lack of information.
- In the rare case you truly don't need to account for timezones,
  or Daylight Saving Time transitions. For example, when modeling
  time in a simulation game.
";
pub(crate) const REPEATEDTIME: &CStr = c"\
A datetime is repeated in a timezone, e.g. because of DST";
pub(crate) const SKIPPEDTIME: &CStr = c"\
A datetime is skipped in a timezone, e.g. because of DST";
pub(crate) const TIME: &CStr = c"\
Time of day without a date component

Example
-------
>>> t = Time(12, 30, 0)
Time(12:30:00)

";
pub(crate) const TIMEDELTA: &CStr = c"\
A duration consisting of a precise time: hours, minutes, (nano)seconds

The inputs are normalized, so 90 minutes becomes 1 hour and 30 minutes,
for example.

Examples
--------
>>> d = TimeDelta(hours=1, minutes=30)
TimeDelta(\"PT1h30m\")
>>> d.in_minutes()
90.0

Note
----
A shorter way to instantiate a timedelta is to use the helper functions
:func:`~whenever.hours`, :func:`~whenever.minutes`, etc.

";
pub(crate) const TIMEZONENOTFOUNDERROR: &CStr = c"\
A timezone with the given ID was not found";
pub(crate) const YEARMONTH: &CStr = c"\
A year and month without a day component

Useful for representing recurring events or billing periods.

Example
-------
>>> ym = YearMonth(2021, 1)
YearMonth(\"2021-01\")
";
pub(crate) const ZONEDDATETIME: &CStr = c"\
A datetime associated with a timezone in the IANA database.
Useful for representing the exact time at a specific location.

Example
-------
>>> ZonedDateTime(2024, 12, 8, hour=11, tz=\"Europe/Paris\")
ZonedDateTime(\"2024-12-08 11:00:00+01:00[Europe/Paris]\")
>>> # Explicitly resolve ambiguities during DST transitions
>>> ZonedDateTime(2023, 10, 29, 1, 15, tz=\"Europe/London\", disambiguate=\"earlier\")
ZonedDateTime(\"2023-10-29 01:15:00+01:00[Europe/London]\")

Important
---------
To use this type properly, read more about
`ambiguity in timezones <https://whenever.rtfd.io/en/latest/overview.html#ambiguity-in-timezones>`_.
";
pub(crate) const DAYS: &CStr = c"\
Create a :class:`~DateDelta` with the given number of days.
``days(1) == DateDelta(days=1)``
";
pub(crate) const HOURS: &CStr = c"\
Create a :class:`~TimeDelta` with the given number of hours.
``hours(1) == TimeDelta(hours=1)``
";
pub(crate) const MICROSECONDS: &CStr = c"\
Create a :class:`TimeDelta` with the given number of microseconds.
``microseconds(1) == TimeDelta(microseconds=1)``
";
pub(crate) const MILLISECONDS: &CStr = c"\
Create a :class:`TimeDelta` with the given number of milliseconds.
``milliseconds(1) == TimeDelta(milliseconds=1)``
";
pub(crate) const MINUTES: &CStr = c"\
Create a :class:`TimeDelta` with the given number of minutes.
``minutes(1) == TimeDelta(minutes=1)``
";
pub(crate) const MONTHS: &CStr = c"\
Create a :class:`~DateDelta` with the given number of months.
``months(1) == DateDelta(months=1)``
";
pub(crate) const NANOSECONDS: &CStr = c"\
Create a :class:`TimeDelta` with the given number of nanoseconds.
``nanoseconds(1) == TimeDelta(nanoseconds=1)``
";
pub(crate) const RESET_SYSTEM_TZ: &CStr = c"\
Resets the cached system timezone to the current system timezone.";
pub(crate) const SECONDS: &CStr = c"\
Create a :class:`TimeDelta` with the given number of seconds.
``seconds(1) == TimeDelta(seconds=1)``
";
pub(crate) const WEEKS: &CStr = c"\
Create a :class:`~DateDelta` with the given number of weeks.
``weeks(1) == DateDelta(weeks=1)``
";
pub(crate) const YEARS: &CStr = c"\
Create a :class:`~DateDelta` with the given number of years.
``years(1) == DateDelta(years=1)``
";
pub(crate) const DATE_ADD: &CStr = c"\
add($self, delta=None, /, *, years=0, months=0, weeks=0, days=0)
--

Add a components to a date.

See :ref:`the docs on arithmetic <arithmetic>` for more information.

Example
-------
>>> d = Date(2021, 1, 2)
>>> d.add(years=1, months=2, days=3)
Date(\"2022-03-05\")
>>> Date(2020, 2, 29).add(years=1)
Date(\"2021-02-28\")
";
pub(crate) const DATE_AT: &CStr = c"\
Combine a date with a time to create a datetime

Example
-------
>>> d = Date(2021, 1, 2)
>>> d.at(Time(12, 30))
PlainDateTime(\"2021-01-02 12:30:00\")

You can use methods like :meth:`~PlainDateTime.assume_utc`
or :meth:`~PlainDateTime.assume_tz` to find the corresponding exact time.
";
pub(crate) const DATE_DAY_OF_WEEK: &CStr = c"\
The day of the week

Example
-------
>>> Date(2021, 1, 2).day_of_week()
Weekday.SATURDAY
>>> Weekday.SATURDAY.value
6  # the ISO value
";
pub(crate) const DATE_DAYS_SINCE: &CStr = c"\
Calculate the number of days this day is after another date.
If the other date is after this date, the result is negative.

Example
-------
>>> Date(2021, 1, 5).days_since(Date(2021, 1, 2))
3

Note
----
If you're interested in calculating the difference
in terms of days **and** months, use the subtraction operator instead.
";
pub(crate) const DATE_DAYS_UNTIL: &CStr = c"\
Calculate the number of days from this date to another date.
If the other date is before this date, the result is negative.

Example
-------
>>> Date(2021, 1, 2).days_until(Date(2021, 1, 5))
3

Note
----
If you're interested in calculating the difference
in terms of days **and** months, use the subtraction operator instead.
";
pub(crate) const DATE_FORMAT_ISO: &CStr = c"\
format_iso($self, *, basic=False)
--

Format as the ISO 8601 date format.

Inverse of :meth:`parse_iso`.

Example
-------
>>> Date(2021, 1, 2).format_iso()
'2021-01-02'
>>> Date(1992, 9, 4).format_iso(basic=True)
'19920904'
";
pub(crate) const DATE_FROM_PY_DATE: &CStr = c"\
Create from a :class:`~datetime.date`

Example
-------
>>> Date.from_py_date(date(2021, 1, 2))
Date(\"2021-01-02\")
";
pub(crate) const DATE_MONTH_DAY: &CStr = c"\
The month and day (without a year component)

Example
-------
>>> Date(2021, 1, 2).month_day()
MonthDay(\"--01-02\")
";
pub(crate) const DATE_PARSE_ISO: &CStr = c"\
Parse a date from an ISO8601 string

The following formats are accepted:
- ``YYYY-MM-DD`` (\"extended\" format)
- ``YYYYMMDD`` (\"basic\" format)

Inverse of :meth:`format_iso`

Example
-------
>>> Date.parse_iso(\"2021-01-02\")
Date(\"2021-01-02\")
";
pub(crate) const DATE_PY_DATE: &CStr = c"\
Convert to a standard library :class:`~datetime.date`";
pub(crate) const DATE_REPLACE: &CStr = c"\
replace($self, /, *, year=None, month=None, day=None)
--

Create a new instance with the given fields replaced

Example
-------
>>> d = Date(2021, 1, 2)
>>> d.replace(day=4)
Date(\"2021-01-04\")
";
pub(crate) const DATE_SUBTRACT: &CStr = c"\
subtract($self, delta=None, /, *, years=0, months=0, weeks=0, days=0)
--

Subtract components from a date.

See :ref:`the docs on arithmetic <arithmetic>` for more information.

Example
-------
>>> d = Date(2021, 1, 2)
>>> d.subtract(years=1, months=2, days=3)
Date(\"2019-10-30\")
>>> Date(2021, 3, 1).subtract(years=1)
Date(\"2020-03-01\")
";
pub(crate) const DATE_TODAY_IN_SYSTEM_TZ: &CStr = c"\
Get the current date in the system's local timezone.

Alias for ``Instant.now().to_system_tz().date()``.

Example
-------
>>> Date.today_in_system_tz()
Date(\"2021-01-02\")
";
pub(crate) const DATE_YEAR_MONTH: &CStr = c"\
The year and month (without a day component)

Example
-------
>>> Date(2021, 1, 2).year_month()
YearMonth(\"2021-01\")
";
pub(crate) const DATEDELTA_FORMAT_ISO: &CStr = c"\
Format as the *popular interpretation* of the ISO 8601 duration format.
May not strictly adhere to (all versions of) the standard.
See :ref:`here <iso8601-durations>` for more information.

Inverse of :meth:`parse_iso`.

The format looks like this:

.. code-block:: text

    P(nY)(nM)(nD)

For example:

.. code-block:: text

    P1D
    P2M
    P1Y2M3W4D

Example
-------
>>> p = DateDelta(years=1, months=2, weeks=3, days=11)
>>> p.format_iso()
'P1Y2M3W11D'
>>> DateDelta().format_iso()
'P0D'
";
pub(crate) const DATEDELTA_IN_MONTHS_DAYS: &CStr = c"\
Convert to a tuple of months and days.

Example
-------
>>> p = DateDelta(months=25, days=9)
>>> p.in_months_days()
(25, 9)
>>> DateDelta(months=-13, weeks=-5)
(-13, -35)
";
pub(crate) const DATEDELTA_IN_YEARS_MONTHS_DAYS: &CStr = c"\
Convert to a tuple of years, months, and days.

Example
-------
>>> p = DateDelta(years=1, months=2, days=11)
>>> p.in_years_months_days()
(1, 2, 11)
";
pub(crate) const DATEDELTA_PARSE_ISO: &CStr = c"\
Parse the *popular interpretation* of the ISO 8601 duration format.
Does not parse all possible ISO 8601 durations.
See :ref:`here <iso8601-durations>` for more information.

Inverse of :meth:`format_iso`

Example
-------
>>> DateDelta.parse_iso(\"P1W11D\")
DateDelta(\"P1w11d\")
>>> DateDelta.parse_iso(\"-P3m\")
DateDelta(-P3m)

Note
----
Only durations without time component are accepted.
``P0D`` is valid, but ``PT0S`` is not.

Note
----
The number of digits in each component is limited to 8.
";
pub(crate) const DATETIMEDELTA_DATE_PART: &CStr = c"\
The date part of the delta";
pub(crate) const DATETIMEDELTA_FORMAT_ISO: &CStr = c"\
Format as the *popular interpretation* of the ISO 8601 duration format.
May not strictly adhere to (all versions of) the standard.
See :ref:`here <iso8601-durations>` for more information.

Inverse of :meth:`parse_iso`.

The format is:

.. code-block:: text

    P(nY)(nM)(nD)T(nH)(nM)(nS)

Example
-------
>>> d = DateTimeDelta(
...     weeks=1,
...     days=11,
...     hours=4,
...     milliseconds=12,
... )
>>> d.format_iso()
'P1W11DT4H0.012S'
";
pub(crate) const DATETIMEDELTA_IN_MONTHS_DAYS_SECS_NANOS: &CStr = c"\
Convert to a tuple of (months, days, seconds, nanoseconds)

Example
-------
>>> d = DateTimeDelta(weeks=1, days=11, hours=4, microseconds=2)
>>> d.in_months_days_secs_nanos()
(0, 18, 14_400, 2000)
";
pub(crate) const DATETIMEDELTA_PARSE_ISO: &CStr = c"\
Parse the *popular interpretation* of the ISO 8601 duration format.
Does not parse all possible ISO 8601 durations.
See :ref:`here <iso8601-durations>` for more information.

Examples:

.. code-block:: text

   P4D        # 4 days
   PT4H       # 4 hours
   PT3M40.5S  # 3 minutes and 40.5 seconds
   P1W11DT4H  # 1 week, 11 days, and 4 hours
   -PT7H4M    # -7 hours and -4 minutes (-7:04:00)
   +PT7H4M    # 7 hours and 4 minutes (7:04:00)

Inverse of :meth:`format_iso`

Example
-------
>>> DateTimeDelta.parse_iso(\"-P1W11DT4H\")
DateTimeDelta(-P1w11dT4h)
";
pub(crate) const DATETIMEDELTA_TIME_PART: &CStr = c"\
The time part of the delta";
pub(crate) const INSTANT_ADD: &CStr = c"\
add($self, delta=None, /, *, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0)
--

Add a time amount to this instant.

See the `docs on arithmetic <https://whenever.readthedocs.io/en/latest/overview.html#arithmetic>`_ for more information.
";
pub(crate) const INSTANT_FORMAT_ISO: &CStr = c"\
format_iso($self, *, unit='auto', basic=False, sep='T')
--

Convert to the ISO 8601 string representation.

The inverse of the ``parse_iso()`` method.
";
pub(crate) const INSTANT_FORMAT_RFC2822: &CStr = c"\
Format as an RFC 2822 string.

The inverse of the ``parse_rfc2822()`` method.

Note
----
The output is also compatible with the (stricter) RFC 9110 standard.

Example
-------
>>> Instant.from_utc(2020, 8, 8, hour=23, minute=12).format_rfc2822()
\"Sat, 08 Aug 2020 23:12:00 GMT\"
";
pub(crate) const INSTANT_FROM_PY_DATETIME: &CStr = c"\
Create an Instant from a standard library ``datetime`` object.
The datetime must be aware.

The inverse of the ``py_datetime()`` method.
";
pub(crate) const INSTANT_FROM_TIMESTAMP: &CStr = c"\
Create an Instant from a UNIX timestamp (in seconds).

The inverse of the ``timestamp()`` method.
";
pub(crate) const INSTANT_FROM_TIMESTAMP_MILLIS: &CStr = c"\
Create an Instant from a UNIX timestamp (in milliseconds).

The inverse of the ``timestamp_millis()`` method.
";
pub(crate) const INSTANT_FROM_TIMESTAMP_NANOS: &CStr = c"\
Create an Instant from a UNIX timestamp (in nanoseconds).

The inverse of the ``timestamp_nanos()`` method.
";
pub(crate) const INSTANT_FROM_UTC: &CStr = c"\
from_utc(year, month, day, hour=0, minute=0, second=0, *, nanosecond=0)
--

Create an Instant defined by a UTC date and time.";
pub(crate) const INSTANT_NOW: &CStr = c"\
Create an Instant from the current time.";
pub(crate) const INSTANT_PARSE_ISO: &CStr = c"\
Parse an ISO 8601 string. Supports basic and extended formats,
but not week dates or ordinal dates.

See the `docs on ISO8601 support <https://whenever.readthedocs.io/en/latest/overview.html#iso-8601>`_ for more information.

The inverse of the ``format_iso()`` method.
";
pub(crate) const INSTANT_PARSE_RFC2822: &CStr = c"\
Parse a UTC datetime in RFC 2822 format.

The inverse of the ``format_rfc2822()`` method.

Example
-------
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 GMT\")
Instant(\"2020-08-15 23:12:00Z\")

>>> # also valid:
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 +0000\")
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 +0800\")
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 -0000\")
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 UT\")
>>> Instant.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 MST\")

Note
----
- Although technically part of the RFC 2822 standard,
  comments within folding whitespace are not supported.
";
pub(crate) const INSTANT_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even')
--

Round the instant to the specified unit and increment.
Various rounding modes are available.

Examples
--------
>>> Instant.from_utc(2020, 1, 1, 12, 39, 59).round(\"minute\", 15)
Instant(\"2020-01-01 12:45:00Z\")
>>> Instant.from_utc(2020, 1, 1, 8, 9, 13).round(\"second\", 5, mode=\"floor\")
Instant(\"2020-01-01 08:09:10Z\")
";
pub(crate) const INSTANT_SUBTRACT: &CStr = c"\
subtract($self, delta=None, /, *, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0)
--

Subtract a time amount from this instant.

See the `docs on arithmetic <https://whenever.readthedocs.io/en/latest/overview.html#arithmetic>`_ for more information.
";
pub(crate) const MONTHDAY_FORMAT_ISO: &CStr = c"\
Format as the ISO 8601 month-day format.

Inverse of ``parse_iso``.

Example
-------
>>> MonthDay(10, 8).format_iso()
'--10-08'

Note
----
This format is officially only part of the 2000 edition of the
ISO 8601 standard. There is no alternative for month-day
in the newer editions. However, it is still widely used in other libraries.
";
pub(crate) const MONTHDAY_IN_YEAR: &CStr = c"\
Create a date from this month-day with a given day

Example
-------
>>> MonthDay(8, 1).in_year(2025)
Date(\"2025-08-01\")

Note
----
This method will raise a ``ValueError`` if the month-day is a leap day
and the year is not a leap year.
";
pub(crate) const MONTHDAY_IS_LEAP: &CStr = c"\
Check if the month-day is February 29th

Example
-------
>>> MonthDay(2, 29).is_leap()
True
>>> MonthDay(3, 1).is_leap()
False
";
pub(crate) const MONTHDAY_PARSE_ISO: &CStr = c"\
Create from the ISO 8601 format ``--MM-DD`` or ``--MMDD``.

Inverse of :meth:`format_iso`

Example
-------
>>> MonthDay.parse_iso(\"--11-23\")
MonthDay(\"--11-23\")
";
pub(crate) const MONTHDAY_REPLACE: &CStr = c"\
replace($self, /, *, month=None, day=None)
--

Create a new instance with the given fields replaced

Example
-------
>>> d = MonthDay(11, 23)
>>> d.replace(month=3)
MonthDay(\"--03-23\")
";
pub(crate) const OFFSETDATETIME_ADD: &CStr = c"\
add($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, ignore_dst=False)
--

Add a time amount to this datetime.

Important
---------
Shifting a fixed-offset datetime implicitly ignore DST
and other timezone changes. This because it isn't guaranteed that
the same offset will be valid at the resulting time.
If you want to account for DST, convert to a ``ZonedDateTime`` first.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method.

For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const OFFSETDATETIME_FORMAT_ISO: &CStr = c"\
format_iso($self, *, unit='auto', basic=False, sep='T')
--

Convert to the popular ISO format ``YYYY-MM-DDTHH:MM:SS±HH:MM``

The inverse of the ``parse_iso()`` method.
";
pub(crate) const OFFSETDATETIME_FORMAT_RFC2822: &CStr = c"\
Format as an RFC 2822 string.

The inverse of the ``parse_rfc2822()`` method.

Example
-------
>>> OffsetDateTime(2020, 8, 15, 23, 12, offset=hours(2)).format_rfc2822()
\"Sat, 15 Aug 2020 23:12:00 +0200\"
";
pub(crate) const OFFSETDATETIME_FROM_PY_DATETIME: &CStr = c"\
Create an instance from a standard library ``datetime`` object.
The datetime must be aware.

The inverse of the ``py_datetime()`` method.

";
pub(crate) const OFFSETDATETIME_FROM_TIMESTAMP: &CStr = c"\
from_timestamp(i, /, *, offset, ignore_dst=False)
--

Create an instance from a UNIX timestamp (in seconds).

The inverse of the ``timestamp()`` method.

Important
---------
Creating an instance from a UNIX timestamp implicitly ignores DST
and other timezone changes. This because you don't strictly
know if the given offset is correct for an arbitrary timestamp.
Instead, use ``Instant.from_timestamp()``
or ``ZonedDateTime.from_timestamp()`` if you know the timezone.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method. For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const OFFSETDATETIME_FROM_TIMESTAMP_MILLIS: &CStr = c"\
from_timestamp_millis(i, /, *, offset, ignore_dst=False)
--

Create an instance from a UNIX timestamp (in milliseconds).

The inverse of the ``timestamp_millis()`` method.

Important
---------
Creating an instance from a UNIX timestamp implicitly ignores DST
and other timezone changes. This because you don't strictly
know if the given offset is correct for an arbitrary timestamp.
Instead, use ``Instant.from_timestamp_millis()``
or ``ZonedDateTime.from_timestamp_millis()`` if you know the timezone.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method. For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const OFFSETDATETIME_FROM_TIMESTAMP_NANOS: &CStr = c"\
from_timestamp_nanos(i, /, *, offset, ignore_dst=False)
--

Create an instance from a UNIX timestamp (in nanoseconds).

The inverse of the ``timestamp_nanos()`` method.

Important
---------
Creating an instance from a UNIX timestamp implicitly ignores DST
and other timezone changes. This because you don't strictly
know if the given offset is correct for an arbitrary timestamp.
Instead, use ``Instant.from_timestamp_nanos()``
or ``ZonedDateTime.from_timestamp_nanos()`` if you know the timezone.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method. For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const OFFSETDATETIME_NOW: &CStr = c"\
now(offset, /, *, ignore_dst=False)
--

Create an instance from the current time.

Important
---------
Getting the current time with a fixed offset implicitly ignores DST
and other timezone changes. Instead, use ``Instant.now()`` or
``ZonedDateTime.now(<tz_id>)`` if you know the timezone.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method. For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const OFFSETDATETIME_PARSE_ISO: &CStr = c"\
Parse the popular ISO format ``YYYY-MM-DDTHH:MM:SS±HH:MM``

The inverse of the ``format_iso()`` method.

Example
-------
>>> OffsetDateTime.parse_iso(\"2020-08-15T23:12:00+02:00\")
OffsetDateTime(\"2020-08-15 23:12:00+02:00\")
";
pub(crate) const OFFSETDATETIME_PARSE_RFC2822: &CStr = c"\
Parse an offset datetime in RFC 2822 format.

The inverse of the ``format_rfc2822()`` method.

Example
-------
>>> OffsetDateTime.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 +0200\")
OffsetDateTime(\"2020-08-15 23:12:00+02:00\")
>>> # also valid:
>>> OffsetDateTime.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 UT\")
>>> OffsetDateTime.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 GMT\")
>>> OffsetDateTime.parse_rfc2822(\"Sat, 15 Aug 2020 23:12:00 MST\")

Note
----
- Strictly speaking, an offset of ``-0000`` means that the offset
  is \"unknown\". Here, we treat it the same as +0000.
- Although technically part of the RFC 2822 standard,
  comments within folding whitespace are not supported.
";
pub(crate) const OFFSETDATETIME_PARSE_STRPTIME: &CStr = c"\
parse_strptime(s, /, *, format)
--

Parse a datetime with offset using the standard library ``strptime()`` method.

Example
-------
>>> OffsetDateTime.parse_strptime(\"2020-08-15+0200\", format=\"%Y-%m-%d%z\")
OffsetDateTime(\"2020-08-15 00:00:00+02:00\")

Note
----
This method defers to the standard library ``strptime()`` method,
which may behave differently in different Python versions.
It also only supports up to microsecond precision.

Important
---------
An offset *must* be present in the format string.
This means you MUST include the directive ``%z``, ``%Z``, or ``%:z``.
To parse a datetime without an offset, use ``PlainDateTime`` instead.
";
pub(crate) const OFFSETDATETIME_REPLACE: &CStr = c"\
replace($self, /, *, year=None, month=None, weeks=0, day=None, hour=None, minute=None, second=None, nanosecond=None, offset=None, ignore_dst=False)
--

Construct a new instance with the given fields replaced.

Important
---------
Replacing fields of an offset datetime implicitly ignores DST
and other timezone changes. This because it isn't guaranteed that
the same offset will be valid at the new time.
If you want to account for DST, convert to a ``ZonedDateTime`` first.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method.
";
pub(crate) const OFFSETDATETIME_REPLACE_DATE: &CStr = c"\
replace_date($self, date, /, *, ignore_dst=False)
--

Construct a new instance with the date replaced.

See the ``replace()`` method for more information.
";
pub(crate) const OFFSETDATETIME_REPLACE_TIME: &CStr = c"\
replace_time($self, time, /, *, ignore_dst=False)
--

Construct a new instance with the time replaced.

See the ``replace()`` method for more information.
";
pub(crate) const OFFSETDATETIME_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even', *, ignore_dst=False)
--

Round the datetime to the specified unit and increment.
Different rounding modes are available.

Examples
--------
>>> d = OffsetDateTime(2020, 8, 15, 23, 24, 18, offset=+4)
>>> d.round(\"day\")
OffsetDateTime(\"2020-08-16 00:00:00[+04:00]\")
>>> d.round(\"minute\", increment=15, mode=\"floor\")
OffsetDateTime(\"2020-08-15 23:15:00[+04:00]\")

Note
----
* The ``ignore_dst`` parameter is required, because it is possible
  (though unlikely) that the rounded datetime will not have the same offset.
* This method has similar behavior to the ``round()`` method of
  Temporal objects in JavaScript.
";
pub(crate) const OFFSETDATETIME_SUBTRACT: &CStr = c"\
subtract($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, ignore_dst=False)
--

Subtract a time amount from this datetime.

Important
---------
Shifting a fixed-offset datetime implicitly ignore DST
and other timezone changes. This because it isn't guaranteed that
the same offset will be valid at the resulting time.
If you want to account for DST, convert to a ``ZonedDateTime`` first.
Or, if you want to ignore DST and accept potentially incorrect offsets,
pass ``ignore_dst=True`` to this method.

For more information, see
`the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const PLAINDATETIME_ADD: &CStr = c"\
add($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, ignore_dst=False)
--

Add a time amount to this datetime.

Important
---------
Shifting a ``PlainDateTime`` with **exact units** (e.g. hours, seconds)
implicitly ignores DST transitions and other timezone changes.
If you need to account for these, convert to a ``ZonedDateTime`` first.
Or, if you don't know the timezone and accept potentially incorrect results
during DST transitions, pass ``ignore_dst=True``.

See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_
for more information.
";
pub(crate) const PLAINDATETIME_ASSUME_FIXED_OFFSET: &CStr = c"\
Assume the datetime has the given offset, creating an ``OffsetDateTime``.

Example
-------
>>> PlainDateTime(2020, 8, 15, 23, 12).assume_fixed_offset(+2)
OffsetDateTime(\"2020-08-15 23:12:00+02:00\")
";
pub(crate) const PLAINDATETIME_ASSUME_SYSTEM_TZ: &CStr = c"\
assume_system_tz($self, disambiguate='compatible')
--

Assume the datetime is in the system timezone,
creating a ``ZonedDateTime``.

Note
----
The local time may be ambiguous in the system timezone
(e.g. during a DST transition). You can explicitly
specify how to handle such a situation using the ``disambiguate`` argument.
See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#ambiguity-in-timezones>`_
for more information.

Example
-------
>>> d = PlainDateTime(2020, 8, 15, 23, 12)
>>> # assuming system timezone is America/New_York
>>> d.assume_system_tz(disambiguate=\"raise\")
ZonedDateTime(\"2020-08-15 23:12:00-04:00[America/New_York]\")
";
pub(crate) const PLAINDATETIME_ASSUME_TZ: &CStr = c"\
assume_tz($self, tz, /, disambiguate='compatible')
--

Assume the datetime is in the given timezone,
creating a ``ZonedDateTime``.

Note
----
The local time may be ambiguous in the given timezone
(e.g. during a DST transition). You can explicitly
specify how to handle such a situation using the ``disambiguate`` argument.
See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#ambiguity-in-timezones>`_
for more information.

Example
-------
>>> d = PlainDateTime(2020, 8, 15, 23, 12)
>>> d.assume_tz(\"Europe/Amsterdam\", disambiguate=\"raise\")
ZonedDateTime(\"2020-08-15 23:12:00+02:00[Europe/Amsterdam]\")
";
pub(crate) const PLAINDATETIME_ASSUME_UTC: &CStr = c"\
Assume the datetime is in UTC, creating an ``Instant``.

Example
-------
>>> PlainDateTime(2020, 8, 15, 23, 12).assume_utc()
Instant(\"2020-08-15 23:12:00Z\")
";
pub(crate) const PLAINDATETIME_DIFFERENCE: &CStr = c"\
difference($self, other, /, *, ignore_dst=False)
--

Calculate the difference between two times without a timezone.

Important
---------
The difference between two datetimes without a timezone implicitly ignores
DST transitions and other timezone changes.
To perform DST-safe operations, convert to a ``ZonedDateTime`` first.
Or, if you don't know the timezone and accept potentially incorrect results
during DST transitions, pass ``ignore_dst=True``.
For more information,
see `the docs <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_.
";
pub(crate) const PLAINDATETIME_FORMAT_ISO: &CStr = c"\
format_iso($self, *, unit='auto', basic=False, sep='T')
--

Convert to the popular ISO format ``YYYY-MM-DDTHH:MM:SS``

The inverse of the ``parse_iso()`` method.
";
pub(crate) const PLAINDATETIME_FROM_PY_DATETIME: &CStr = c"\
Create an instance from a \"naive\" standard library ``datetime`` object";
pub(crate) const PLAINDATETIME_PARSE_ISO: &CStr = c"\
Parse the popular ISO format ``YYYY-MM-DDTHH:MM:SS``

The inverse of the ``format_iso()`` method.

Example
-------
>>> PlainDateTime.parse_iso(\"2020-08-15T23:12:00\")
PlainDateTime(\"2020-08-15 23:12:00\")
";
pub(crate) const PLAINDATETIME_PARSE_STRPTIME: &CStr = c"\
parse_strptime(s, /, *, format)
--

Parse a plain datetime using the standard library ``strptime()`` method.

Example
-------
>>> PlainDateTime.parse_strptime(\"2020-08-15\", format=\"%d/%m/%Y_%H:%M\")
PlainDateTime(\"2020-08-15 00:00:00\")

Note
----
This method defers to the standard library ``strptime()`` method,
which may behave differently in different Python versions.
It also only supports up to microsecond precision.

Important
---------
There may not be an offset in the format string.
This means you CANNOT use the directives ``%z``, ``%Z``, or ``%:z``.
Use ``OffsetDateTime`` to parse datetimes with an offset.
";
pub(crate) const PLAINDATETIME_REPLACE: &CStr = c"\
replace($self, /, *, year=None, month=None, day=None, hour=None, minute=None, second=None, nanosecond=None)
--

Construct a new instance with the given fields replaced.";
pub(crate) const PLAINDATETIME_REPLACE_DATE: &CStr = c"\
Construct a new instance with the date replaced.";
pub(crate) const PLAINDATETIME_REPLACE_TIME: &CStr = c"\
Construct a new instance with the time replaced.";
pub(crate) const PLAINDATETIME_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even')
--

Round the datetime to the specified unit and increment.
Different rounding modes are available.

Examples
--------
>>> d = PlainDateTime(2020, 8, 15, 23, 24, 18)
>>> d.round(\"day\")
PlainDateTime(\"2020-08-16 00:00:00\")
>>> d.round(\"minute\", increment=15, mode=\"floor\")
PlainDateTime(\"2020-08-15 23:15:00\")

Note
----
This method has similar behavior to the ``round()`` method of
Temporal objects in JavaScript.
";
pub(crate) const PLAINDATETIME_SUBTRACT: &CStr = c"\
subtract($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, ignore_dst=False)
--

Subtract a time amount from this datetime.

Important
---------
Shifting a ``PlainDateTime`` with **exact units** (e.g. hours, seconds)
implicitly ignores DST transitions and other timezone changes.
If you need to account for these, convert to a ``ZonedDateTime`` first.
Or, if you don't know the timezone and accept potentially incorrect results
during DST transitions, pass ``ignore_dst=True``.

See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic>`_
for more information.
";
pub(crate) const TIME_FORMAT_ISO: &CStr = c"\
format_iso($self, *, unit='auto', basic=False)
--

Format as the ISO 8601 time format.

Inverse of :meth:`parse_iso`.

Example
-------
>>> Time(12, 30, 0).format_iso(unit='millisecond')
'12:30:00.000'
>>> Time(4, 0, 59, nanosecond=40_000).format_iso(basic=True)
'040059.00004'
";
pub(crate) const TIME_FROM_PY_TIME: &CStr = c"\
Create from a :class:`~datetime.time`

Example
-------
>>> Time.from_py_time(time(12, 30, 0))
Time(12:30:00)

`fold` value is ignored.
";
pub(crate) const TIME_ON: &CStr = c"\
Combine a time with a date to create a datetime

Example
-------
>>> t = Time(12, 30)
>>> t.on(Date(2021, 1, 2))
PlainDateTime(\"2021-01-02 12:30:00\")

Then, use methods like :meth:`~PlainDateTime.assume_utc`
or :meth:`~PlainDateTime.assume_tz`
to find the corresponding exact time.
";
pub(crate) const TIME_PARSE_ISO: &CStr = c"\
Create from the ISO 8601 time format

Inverse of :meth:`format_iso`

Example
-------
>>> Time.parse_iso(\"12:30:00\")
Time(12:30:00)
";
pub(crate) const TIME_PY_TIME: &CStr = c"\
Convert to a standard library :class:`~datetime.time`";
pub(crate) const TIME_REPLACE: &CStr = c"\
replace($self, /, *, hour=None, minute=None, second=None, nanosecond=None)
--

Create a new instance with the given fields replaced

Example
-------
>>> t = Time(12, 30, 0)
>>> d.replace(minute=3, nanosecond=4_000)
Time(12:03:00.000004)

";
pub(crate) const TIME_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even')
--

Round the time to the specified unit and increment.
Various rounding modes are available.

Examples
--------
>>> Time(12, 39, 59).round(\"minute\", 15)
Time(12:45:00)
>>> Time(8, 9, 13).round(\"second\", 5, mode=\"floor\")
Time(08:09:10)
";
pub(crate) const TIMEDELTA_FORMAT_ISO: &CStr = c"\
Format as the *popular interpretation* of the ISO 8601 duration format.
May not strictly adhere to (all versions of) the standard.
See :ref:`here <iso8601-durations>` for more information.

Inverse of :meth:`parse_iso`.

Example
-------
>>> TimeDelta(hours=1, minutes=30).format_iso()
'PT1H30M'
";
pub(crate) const TIMEDELTA_FROM_PY_TIMEDELTA: &CStr = c"\
Create from a :class:`~datetime.timedelta`

Inverse of :meth:`py_timedelta`

Example
-------
>>> TimeDelta.from_py_timedelta(timedelta(seconds=5400))
TimeDelta(\"PT1h30m\")

Note
----
Subclasses of :class:`~datetime.timedelta` are not accepted
because they often add additional state that cannot be represented
in a :class:`TimeDelta`.
";
pub(crate) const TIMEDELTA_IN_DAYS_OF_24H: &CStr = c"\
The total size in days (of exactly 24 hours each)

Note
----
Note that this may not be the same as days on the calendar,
since some days have 23 or 25 hours due to daylight saving time.
";
pub(crate) const TIMEDELTA_IN_HOURS: &CStr = c"\
The total size in hours

Example
-------
>>> d = TimeDelta(hours=1, minutes=30)
>>> d.in_hours()
1.5
";
pub(crate) const TIMEDELTA_IN_HRS_MINS_SECS_NANOS: &CStr = c"\
Convert to a tuple of (hours, minutes, seconds, nanoseconds)

Example
-------
>>> d = TimeDelta(hours=1, minutes=30, microseconds=5_000_090)
>>> d.in_hrs_mins_secs_nanos()
(1, 30, 5, 90_000)
";
pub(crate) const TIMEDELTA_IN_MICROSECONDS: &CStr = c"\
The total size in microseconds

>>> d = TimeDelta(seconds=2, nanoseconds=50)
>>> d.in_microseconds()
2_000_000.05
";
pub(crate) const TIMEDELTA_IN_MILLISECONDS: &CStr = c"\
The total size in milliseconds

>>> d = TimeDelta(seconds=2, microseconds=50)
>>> d.in_milliseconds()
2_000.05
";
pub(crate) const TIMEDELTA_IN_MINUTES: &CStr = c"\
The total size in minutes

Example
-------
>>> d = TimeDelta(hours=1, minutes=30, seconds=30)
>>> d.in_minutes()
90.5
";
pub(crate) const TIMEDELTA_IN_NANOSECONDS: &CStr = c"\
The total size in nanoseconds

>>> d = TimeDelta(seconds=2, nanoseconds=50)
>>> d.in_nanoseconds()
2_000_000_050
";
pub(crate) const TIMEDELTA_IN_SECONDS: &CStr = c"\
The total size in seconds

Example
-------
>>> d = TimeDelta(minutes=2, seconds=1, microseconds=500_000)
>>> d.in_seconds()
121.5
";
pub(crate) const TIMEDELTA_PARSE_ISO: &CStr = c"\
Parse the *popular interpretation* of the ISO 8601 duration format.
Does not parse all possible ISO 8601 durations.
See :ref:`here <iso8601-durations>` for more information.

Inverse of :meth:`format_iso`

Example
-------
>>> TimeDelta.parse_iso(\"PT1H80M\")
TimeDelta(\"PT2h20m\")

Note
----
Any duration with a date part is considered invalid.
``PT0S`` is valid, but ``P0D`` is not.
";
pub(crate) const TIMEDELTA_PY_TIMEDELTA: &CStr = c"\
Convert to a :class:`~datetime.timedelta`

Inverse of :meth:`from_py_timedelta`

Note
----
Nanoseconds are truncated to microseconds.
If you need more control over rounding, use :meth:`round` first.

Example
-------
>>> d = TimeDelta(hours=1, minutes=30)
>>> d.py_timedelta()
timedelta(seconds=5400)
";
pub(crate) const TIMEDELTA_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even')
--

Round the delta to the specified unit and increment.
Various rounding modes are available.

Examples
--------
>>> t = TimeDelta(seconds=12345)
TimeDelta(\"PT3h25m45s\")
>>> t.round(\"minute\")
TimeDelta(\"PT3h26m\")
>>> t.round(\"second\", increment=10, mode=\"floor\")
TimeDelta(\"PT3h25m40s\")
";
pub(crate) const YEARMONTH_FORMAT_ISO: &CStr = c"\
Format as the ISO 8601 year-month format.

Inverse of :meth:`parse_iso`.

Example
-------
>>> YearMonth(2021, 1).format_iso()
'2021-01'
";
pub(crate) const YEARMONTH_ON_DAY: &CStr = c"\
Create a date from this year-month with a given day

Example
-------
>>> YearMonth(2021, 1).on_day(2)
Date(\"2021-01-02\")
";
pub(crate) const YEARMONTH_PARSE_ISO: &CStr = c"\
Create from the ISO 8601 format ``YYYY-MM`` or ``YYYYMM``.

Inverse of :meth:`format_iso`

Example
-------
>>> YearMonth.parse_iso(\"2021-01\")
YearMonth(\"2021-01\")
";
pub(crate) const YEARMONTH_REPLACE: &CStr = c"\
replace($self, /, *, year=None, month=None)
--

Create a new instance with the given fields replaced

Example
-------
>>> d = YearMonth(2021, 12)
>>> d.replace(month=3)
YearMonth(\"2021-03\")
";
pub(crate) const ZONEDDATETIME_ADD: &CStr = c"\
add($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, disambiguate=None)
--

Add a time amount to this datetime.

Important
---------
Shifting a ``ZonedDateTime`` with **calendar units** (e.g. months, weeks)
may result in an ambiguous time (e.g. during a DST transition).
Therefore, when adding calendar units, it's recommended to
specify how to handle such a situation using the ``disambiguate`` argument.

See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#arithmetic>`_
for more information.
";
pub(crate) const ZONEDDATETIME_DAY_LENGTH: &CStr = c"\
The duration between the start of the current day and the next.
This is usually 24 hours, but may be different due to timezone transitions.

Example
-------
>>> ZonedDateTime(2020, 8, 15, tz=\"Europe/London\").day_length()
TimeDelta(24:00:00)
>>> ZonedDateTime(2023, 10, 29, tz=\"Europe/Amsterdam\").day_length()
TimeDelta(25:00:00)
";
pub(crate) const ZONEDDATETIME_FORMAT_ISO: &CStr = c"\
format_iso($self, *, unit='auto', basic=False, sep='T', tz='always')
--

Convert to the popular ISO format ``YYYY-MM-DDTHH:MM:SS±HH:MM[TZ_ID]``.

The inverse of the ``parse_iso()`` method.

Use the ``unit`` parameter to control the precision of the time part,
the ``sep`` parameter to control the separator,
and the ``basic`` parameter to use the basic ISO format instead of the extended one.

Example
-------
>>> ZonedDateTime(2020, 8, 15, hour=23, minute=12, tz=\"Europe/London\")
ZonedDateTime(\"2020-08-15 23:12:00+01:00[Europe/London]\")

Important
---------
The timezone ID is a recent extension to the ISO 8601 format (RFC 9557).
Althought it is gaining popularity, it is not yet widely supported
by ISO 8601 parsers.
";
pub(crate) const ZONEDDATETIME_FROM_PY_DATETIME: &CStr = c"\
Create an instance from a standard library ``datetime`` object
with a ``ZoneInfo`` tzinfo.

The inverse of the ``py_datetime()`` method.

Attention
---------
If the datetime is ambiguous (e.g. during a DST transition),
the ``fold`` attribute is used to disambiguate the time.
";
pub(crate) const ZONEDDATETIME_FROM_SYSTEM_TZ: &CStr = c"\
from_system_tz(year, month, day, hour=0, minute=0, second=0, *, nanosecond=0, disambiguate='compatible')
--

Create an instance in the system timezone.

Equivalent to ``ZonedDateTime(..., tz=<the system timezone>)``,
except it also works for system timezones whose corresponding
IANA timezone ID is unknown.

Example
-------
>>> ZonedDateTime.from_system_tz(2020, 8, 15, hour=23, minute=12)
ZonedDateTime(\"2020-08-15 23:12:00+02:00[Europe/Berlin]\")
";
pub(crate) const ZONEDDATETIME_FROM_TIMESTAMP: &CStr = c"\
from_timestamp(i, /, *, tz)
--

Create an instance from a UNIX timestamp (in seconds).

The inverse of the ``timestamp()`` method.
";
pub(crate) const ZONEDDATETIME_FROM_TIMESTAMP_MILLIS: &CStr = c"\
from_timestamp_millis(i, /, *, tz)
--

Create an instance from a UNIX timestamp (in milliseconds).

The inverse of the ``timestamp_millis()`` method.
";
pub(crate) const ZONEDDATETIME_FROM_TIMESTAMP_NANOS: &CStr = c"\
from_timestamp_nanos(i, /, *, tz)
--

Create an instance from a UNIX timestamp (in nanoseconds).

The inverse of the ``timestamp_nanos()`` method.
";
pub(crate) const ZONEDDATETIME_IS_AMBIGUOUS: &CStr = c"\
Whether the date and time-of-day are ambiguous, e.g. due to a DST transition.

Example
-------
>>> ZonedDateTime(2020, 8, 15, 23, tz=\"Europe/London\").is_ambiguous()
False
>>> ZonedDateTime(2023, 10, 29, 2, 15, tz=\"Europe/Amsterdam\").is_ambiguous()
True
";
pub(crate) const ZONEDDATETIME_NOW: &CStr = c"\
Create an instance from the current time in the given timezone.";
pub(crate) const ZONEDDATETIME_NOW_IN_SYSTEM_TZ: &CStr = c"\
Create an instance from the current time in the system timezone.

Equivalent to ``Instant.now().to_system_tz()``.
";
pub(crate) const ZONEDDATETIME_PARSE_ISO: &CStr = c"\
Parse from the popular ISO format ``YYYY-MM-DDTHH:MM:SS±HH:MM[TZ_ID]``

The inverse of the ``format_iso()`` method.

Example
-------
>>> ZonedDateTime.parse_iso(\"2020-08-15T23:12:00+01:00[Europe/London]\")
ZonedDateTime(\"2020-08-15 23:12:00+01:00[Europe/London]\")

Important
---------
The timezone ID is a recent extension to the ISO 8601 format (RFC 9557).
Althought it is gaining popularity, it is not yet widely supported.
";
pub(crate) const ZONEDDATETIME_REPLACE: &CStr = c"\
replace($self, /, *, year=None, month=None, weeks=0, day=None, hour=None, minute=None, second=None, nanosecond=None, tz=None, disambiguate)
--

Construct a new instance with the given fields replaced.

Important
---------
Replacing fields of a ZonedDateTime may result in an ambiguous time
(e.g. during a DST transition). Therefore, it's recommended to
specify how to handle such a situation using the ``disambiguate`` argument.

By default, if the tz remains the same, the offset is used to disambiguate
if possible, falling back to the \"compatible\" strategy if needed.

See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#ambiguity-in-timezones>`_
for more information.
";
pub(crate) const ZONEDDATETIME_REPLACE_DATE: &CStr = c"\
replace_date($self, date, /, disambiguate=None)
--

Construct a new instance with the date replaced.

See the ``replace()`` method for more information.
";
pub(crate) const ZONEDDATETIME_REPLACE_TIME: &CStr = c"\
replace_time($self, time, /, disambiguate=None)
--

Construct a new instance with the time replaced.

See the ``replace()`` method for more information.
";
pub(crate) const ZONEDDATETIME_ROUND: &CStr = c"\
round($self, unit='second', increment=1, mode='half_even')
--

Round the datetime to the specified unit and increment.
Different rounding modes are available.

Examples
--------
>>> d = ZonedDateTime(2020, 8, 15, 23, 24, 18, tz=\"Europe/Paris\")
>>> d.round(\"day\")
ZonedDateTime(\"2020-08-16 00:00:00+02:00[Europe/Paris]\")
>>> d.round(\"minute\", increment=15, mode=\"floor\")
ZonedDateTime(\"2020-08-15 23:15:00+02:00[Europe/Paris]\")

Notes
-----
* In the rare case that rounding results in an ambiguous time,
  the offset is preserved if possible.
  Otherwise, the time is resolved according to the \"compatible\" strategy.
* Rounding in \"day\" mode may be affected by DST transitions.
  i.e. on 23-hour days, 11:31 AM is rounded up.
* This method has similar behavior to the ``round()`` method of
  Temporal objects in JavaScript.
";
pub(crate) const ZONEDDATETIME_START_OF_DAY: &CStr = c"\
The start of the current calendar day.

This is almost always at midnight the same day, but may be different
for timezones which transition at—and thus skip over—midnight.
";
pub(crate) const ZONEDDATETIME_SUBTRACT: &CStr = c"\
subtract($self, delta=None, /, *, years=0, months=0, weeks=0, days=0, hours=0, minutes=0, seconds=0, milliseconds=0, microseconds=0, nanoseconds=0, disambiguate=None)
--

Subtract a time amount from this datetime.

Important
---------
Shifting a ``ZonedDateTime`` with **calendar units** (e.g. months, weeks)
may result in an ambiguous time (e.g. during a DST transition).
Therefore, when adding calendar units, it's recommended to
specify how to handle such a situation using the ``disambiguate`` argument.

See `the documentation <https://whenever.rtfd.io/en/latest/overview.html#arithmetic>`_
for more information.
";
pub(crate) const BASICCONVERSIONS_PY_DATETIME: &CStr = c"\
Convert to a standard library :class:`~datetime.datetime`

Note
----
- Nanoseconds are truncated to microseconds.
  If you wish to customize the rounding behavior, use
  the ``round()`` method first.
- In case of a ZonedDateTime linked to a system timezone without a
  IANA timezone ID, the returned Python datetime will have
  a fixed offset (:class:`~datetime.timezone` tzinfo)
";
pub(crate) const EXACTANDLOCALTIME_TO_INSTANT: &CStr = c"\
Get the underlying instant in time

Example
-------

>>> d = ZonedDateTime(2020, 8, 15, hour=23, tz=\"Europe/Amsterdam\")
>>> d.to_instant()
Instant(\"2020-08-15 21:00:00Z\")
";
pub(crate) const EXACTANDLOCALTIME_TO_PLAIN: &CStr = c"\
Get the underlying date and time (without offset or timezone)

As an inverse, :class:`PlainDateTime` has methods
:meth:`~PlainDateTime.assume_utc`, :meth:`~PlainDateTime.assume_fixed_offset`
, :meth:`~PlainDateTime.assume_tz`, and :meth:`~PlainDateTime.assume_system_tz`
which may require additional arguments.
";
pub(crate) const EXACTTIME_DIFFERENCE: &CStr = c"\
Calculate the difference between two instants in time.

Equivalent to :meth:`__sub__`.

See :ref:`the docs on arithmetic <arithmetic>` for more information.
";
pub(crate) const EXACTTIME_EXACT_EQ: &CStr = c"\
Compare objects by their values
(instead of whether they represent the same instant).
Different types are never equal.

Note
----
If ``a.exact_eq(b)`` is true, then
``a == b`` is also true, but the converse is not necessarily true.

Examples
--------

>>> a = OffsetDateTime(2020, 8, 15, hour=12, offset=1)
>>> b = OffsetDateTime(2020, 8, 15, hour=13, offset=2)
>>> a == b
True  # equivalent instants
>>> a.exact_eq(b)
False  # different values (hour and offset)
>>> a.exact_eq(Instant.now())
TypeError  # different types
";
pub(crate) const EXACTTIME_TIMESTAMP: &CStr = c"\
The UNIX timestamp for this datetime. Inverse of :meth:`from_timestamp`.

Note
----
In contrast to the standard library, this method always returns an integer,
not a float. This is because floating point timestamps are not precise
enough to represent all instants to nanosecond precision.
This decision is consistent with other modern date-time libraries.

Example
-------
>>> Instant.from_utc(1970, 1, 1).timestamp()
0
>>> ts = 1_123_000_000
>>> Instant.from_timestamp(ts).timestamp() == ts
True
";
pub(crate) const EXACTTIME_TIMESTAMP_MILLIS: &CStr = c"\
Like :meth:`timestamp`, but with millisecond precision.";
pub(crate) const EXACTTIME_TIMESTAMP_NANOS: &CStr = c"\
Like :meth:`timestamp`, but with nanosecond precision.";
pub(crate) const EXACTTIME_TO_FIXED_OFFSET: &CStr = c"\
to_fixed_offset($self, offset=None, /)
--

Convert to an OffsetDateTime that represents the same moment in time.

If not offset is given, the offset is taken from the original datetime.
";
pub(crate) const EXACTTIME_TO_SYSTEM_TZ: &CStr = c"\
Convert to a ZonedDateTime of the system's timezone.";
pub(crate) const EXACTTIME_TO_TZ: &CStr = c"\
Convert to a ZonedDateTime that represents the same moment in time.

Raises
------
~whenever.TimeZoneNotFoundError
    If the timezone ID is not found in the timezone database.
";
pub(crate) const LOCALTIME_DATE: &CStr = c"\
The date part of the datetime

Example
-------
>>> d = Instant.from_utc(2021, 1, 2, 3, 4, 5)
>>> d.date()
Date(\"2021-01-02\")

To perform the inverse, use :meth:`Date.at` and a method
like :meth:`~PlainDateTime.assume_utc` ortestoffset
:meth:`~PlainDateTime.assume_tz`:

>>> date.at(time).assume_tz(\"Europe/London\")
";
pub(crate) const LOCALTIME_TIME: &CStr = c"\
The time-of-day part of the datetime

Example
-------
>>> d = ZonedDateTime(2021, 1, 2, 3, 4, 5, tz=\"Europe/Paris\")
ZonedDateTime(\"2021-01-02T03:04:05+01:00[Europe/Paris]\")
>>> d.time()
Time(03:04:05)

To perform the inverse, use :meth:`Time.on` and a method
like :meth:`~PlainDateTime.assume_utc` or
:meth:`~PlainDateTime.assume_tz`:

>>> time.on(date).assume_tz(\"Europe/Paris\")
";
pub(crate) const ADJUST_LOCAL_DATETIME_MSG: &str = "Adjusting a datetime without timezone by time units (e.g. hours and minutess) ignores DST and other timezone changes. To perform DST-safe operations, convert to a ZonedDateTime first. Or, if you don't know the timezone and accept potentially incorrect results during DST transitions, pass `ignore_dst=True`. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const ADJUST_OFFSET_DATETIME_MSG: &str = "Adjusting a fixed offset datetime implicitly ignores DST and other timezone changes. To perform DST-safe operations, convert to a ZonedDateTime first. Or, if you don't know the timezone and accept potentially incorrect results during DST transitions, pass `ignore_dst=True`. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const CANNOT_ROUND_DAY_MSG: &str = "Cannot round to day, because days do not have a fixed length. Due to daylight saving time, some days have 23 or 25 hours.If you wish to round to exaxtly 24 hours, use `round('hour', increment=24)`.";
pub(crate) const DIFF_LOCAL_MSG: &str = "The difference between two datetimes without timezone implicitly ignores DST transitions and other timezone changes. To perform DST-safe operations, convert to a ZonedDateTime first. Or, if you don't know the timezone and accept potentially incorrect results during DST transitions, pass `ignore_dst=True`. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const DIFF_OPERATOR_LOCAL_MSG: &str = "The difference between two datetimes without timezone implicitly ignores DST transitions and other timezone changes. Use the `difference` method instead.";
pub(crate) const FORMAT_ISO_NO_TZ_MSG: &str = "This ZonedDateTime has no timezone ID and cannot be formatted in the standard ISO format, which requires it. This typically means the ZonedDateTime was created from a system timezone with an unknown ID. To format without the timezone designator, set the `tz=` argument to 'never' or 'auto'.";
pub(crate) const OFFSET_NOW_DST_MSG: &str = "Getting the current time with a fixed offset implicitly ignores DST and other timezone changes. Instead, use `Instant.now()` or `ZonedDateTime.now(<tz name>)` if you know the timezone. Or, if you want to ignore DST and accept potentially incorrect offsets, pass `ignore_dst=True` to this method. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const OFFSET_ROUNDING_DST_MSG: &str = "Rounding a fixed offset datetime may (in rare cases) result in a datetime for which the offset is incorrect. This is because the offset may change during DST transitions. To perform DST-safe rounding, convert to a ZonedDateTime first. Or, if you don't know the timezone and accept potentially incorrect results during DST transitions, pass `ignore_dst=True`. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const SHIFT_LOCAL_MSG: &str = "Adding or subtracting a (date)time delta to a datetime without timezone implicitly ignores DST transitions and other timezone changes. Use the `add` or `subtract` method instead.";
pub(crate) const TIMESTAMP_DST_MSG: &str = "Converting from a timestamp with a fixed offset implicitly ignores DST and other timezone changes. To perform a DST-safe conversion, use ZonedDateTime.from_timestamp() instead. Or, if you don't know the timezone and accept potentially incorrect results during DST transitions, pass `ignore_dst=True`. For more information, see whenever.rtfd.io/en/latest/overview.html#dst-safe-arithmetic";
pub(crate) const ZONEINFO_NO_KEY_MSG: &str = "Can't determine the IANA timezone ID of the given datetime:
The 'key' attribute of the datetime's ZoneInfo object is None.

This typically means the ZoneInfo object represents the system timezone with an unknown ID. As an alternative, you can use OffsetDateTime.from_py_datetime(), but be aware this is a lossy conversion that only preserves the current UTC offset and discards future daylight saving rules. Please note that a timezone abbreviation like 'CEST' from datetime.tzname() is not a valid IANA timezone ID and cannot be used here.";
