﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-insights/ApplicationInsights_EXPORTS.h>
#include <aws/application-insights/model/ApplicationComponent.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationInsights {
namespace Model {
class ListComponentsResult {
 public:
  AWS_APPLICATIONINSIGHTS_API ListComponentsResult() = default;
  AWS_APPLICATIONINSIGHTS_API ListComponentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONINSIGHTS_API ListComponentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of application components.</p>
   */
  inline const Aws::Vector<ApplicationComponent>& GetApplicationComponentList() const { return m_applicationComponentList; }
  template <typename ApplicationComponentListT = Aws::Vector<ApplicationComponent>>
  void SetApplicationComponentList(ApplicationComponentListT&& value) {
    m_applicationComponentListHasBeenSet = true;
    m_applicationComponentList = std::forward<ApplicationComponentListT>(value);
  }
  template <typename ApplicationComponentListT = Aws::Vector<ApplicationComponent>>
  ListComponentsResult& WithApplicationComponentList(ApplicationComponentListT&& value) {
    SetApplicationComponentList(std::forward<ApplicationComponentListT>(value));
    return *this;
  }
  template <typename ApplicationComponentListT = ApplicationComponent>
  ListComponentsResult& AddApplicationComponentList(ApplicationComponentListT&& value) {
    m_applicationComponentListHasBeenSet = true;
    m_applicationComponentList.emplace_back(std::forward<ApplicationComponentListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to request the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListComponentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListComponentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ApplicationComponent> m_applicationComponentList;
  bool m_applicationComponentListHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationInsights
}  // namespace Aws
